% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echo_package_functions.R
\name{echo_find}
\alias{echo_find}
\title{Function to calculate the results for all genes using the extended circadian harmonic oscillator (ECHO) method.}
\usage{
echo_find(genes, begin, end, resol, num_reps, low = 1, high = 2,
  run_all_per, paired, rem_unexpr, rem_unexpr_amt = 70,
  rem_unexpr_amt_below = 0, is_normal, is_de_linear_trend, is_smooth)
}
\arguments{
\item{genes}{data frame of genes with the following specifications: first row is column labels, first column has gene labels/names, and all other columns have expression data. This expression data must be ordered by time point then by replicate, and must have evenly spaced time points. Any missing data must have cells left blank.}

\item{begin}{first time point for dataset}

\item{end}{last time point for dataset}

\item{resol}{resolution of time points}

\item{num_reps}{number of replicates}

\item{low}{lower limit when looking for rhythms, in hours. May be unused if finding rhythms of any length within timecouse (run_all_per is TRUE).}

\item{high}{upper limit when looking for rhythms, in hours. May be unused if finding rhythms of any length within timecouse (run_all_per is TRUE).}

\item{run_all_per}{boolean which indicates whether or not rhythms of any length within timecourse should be searched for.}

\item{paired}{if replicate data, whether the replicates are related (paired) or not (unpaired)}

\item{rem_unexpr}{boolean indicating whether genes with less than rem_unexpr_amt percent expression should not be considered}

\item{rem_unexpr_amt}{percentage of expression for which genes should not be considered if rem_unexpr is TRUE}

\item{rem_unexpr_amt_below}{cutoff for expression}

\item{is_normal}{boolean that indicates whether data should be normalized or not}

\item{is_de_linear_trend}{boolean that indicates whether linear trends should be removed from data or not}

\item{is_smooth}{boolean that indicates whether data should be smoothed or not}
}
\value{
results, a data frame which contains:
  \item{Gene Name}{gene name}
  \item{Convergence}{did the fit converge, or descriptor of type of data (constant, unexpressed, etc.)}
  \item{Iterations}{number of iterations}
  \item{Amplitude.Change.Coefficient}{Amplitude change coefficient value for fit}
  \item{Oscillation Type}{Type of oscillation (damped, driven, etc.)}
  \item{Initial.Amplitude}{Initial amplitude value for fit}
  \item{Radian.Frequency}{Radian frequency for fit}
  \item{Period}{Period for fit (in time units)}
  \item{Phase Shift}{Phase shift for fit (radians)}
  \item{Hours Shifted}{Phase shift for fit (hours)}
  \item{Equilibrium Value}{Equilibrium shift for fit}
  \item{Slope}{Slope value of original data, if linear baseline is removed}
  \item{Tau}{Kendall's tau between original and fitted values}
  \item{P-value}{P-value calculated based on Kendall's tau}
  \item{BH Adj P-Value}{Benjamini-Hochberg adjusted p-values}
  \item{BY Adj P-Value}{Benjamini-Yekutieli adjusted p-values}
  \item{Original TPX.Y}{Original values for gene expression at time point X, replicate Y}
  \item{Fitted TPX}{Fitted values for gene expression at time point X}
}
\description{
Function to calculate the results for all genes using the extended circadian harmonic oscillator (ECHO) method.
}
\examples{
# for more elaboration, please see the vignette
# "expressions" is the example echo.find data frame
\donttest{ # long example - commented out
echo_find(genes = expressions, begin = 2, end = 48, resol = 2,
  num_reps = 3, low = 20, high = 26, run_all_per = FALSE,
  paired = FALSE, rem_unexpr = FALSE, rem_unexpr_amt = 70, rem_unexpr_amt_below=0,
  is_normal = FALSE, is_de_linear_trend = FALSE, is_smooth = FALSE)
}
}
