% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objectiveConstraint.R
\name{minConstraint}
\alias{minConstraint}
\title{Min Constraint.}
\usage{
minConstraint(
  nForms,
  itemValues,
  weight = 1,
  whichForms = seq_len(nForms),
  info_text = NULL,
  itemIDs = names(itemValues)
)
}
\arguments{
\item{nForms}{Number of forms to be created.}

\item{itemValues}{Item parameter/values for which the sum per test form should be constrained.}

\item{weight}{a weight for the real-valued variable(s). Useful when multiple constraints are combined. Should only be used if the implications are well understood.}

\item{whichForms}{An integer vector indicating which test forms should be constrained. Defaults to all the test forms.}

\item{info_text}{a character string of length 1, to be used in the \code{"info"}-attribute of the resulting \code{constraint}-object.}

\item{itemIDs}{a character vector of item IDs in correct ordering, or NULL.}
}
\value{
An object of class \code{"constraint"}.
}
\description{
Create \code{min}-constraints related to an item parameter/value. That is, the created
constraints can be used to minimize the sum of the
item values (\code{itemValues}) of the test form.
Note that this constraint can only be used when only one test form has to be assembled.
}
\examples{
# constraint that maximizes the sum of the itemValues
maxConstraint(nForms = 1, itemValues = rep(-2:2, 2))

}
