% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{RFEAT_object}
\alias{RFEAT_object}
\title{RFEAT object}
\usage{
RFEAT_object(
  data,
  x,
  y,
  register_names,
  numStop,
  m,
  s_mtry,
  na.rm,
  forest,
  error,
  OOB
)
}
\arguments{
\item{data}{Dataframe or matrix containing the variables in the model.}

\item{x}{Vector. Column input indexes in data.}

\item{y}{Vector. Column output indexes in data.}

\item{register_names}{String vector. Data rownames.}

\item{numStop}{Integer. Minimun number of observations in a node for a split to be attempted.}

\item{m}{Integer. Number of trees to be built.}

\item{s_mtry}{Select number of inputs in each split.
\itemize{
\item{\code{"Breiman"}}: \code{in / 3}
\item{\code{"DEA1"}}: \code{(t.obs / 2) - out}  
\item{\code{"DEA2"}}: \code{(t.obs / 3) - out}
\item{\code{"DEA3"}}: \code{t.obs - 2 * out}
\item{\code{"DEA4"}}: \code{min(t.obs / out, (t.obs / 3) - out)}
}}

\item{na.rm}{Logical. If \code{TRUE}, NA rows are omitted.}

\item{forest}{A list containing the individual EAT trees.}

\item{error}{Error in forest.}

\item{OOB}{List containing the observations with which each tree has been trained.}
}
\value{
A RFEAT object
}
\description{
This function saves information about the RFEAT model
}
