% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/convert2prob.R
\name{convert2prob}
\alias{convert2prob}
\title{Convert to probability / categorical forecast}
\usage{
convert2prob(x, prob = NULL, threshold = NULL)
}
\arguments{
\item{x}{input vector or matrix}

\item{prob}{thresholds for categorical forecasts (defaults to NULL)}

\item{threshold}{absolute thresholds for categorical forecasts (defaults to NULL)}
}
\value{
Matrix of occurences per class (i.e. the number of ensemble members per class,
or an indicator for the observations)
}
\description{
Convert to probability / categorical forecast
}
\details{
In case both \code{prob} and \code{threshold} are set to \code{NULL}, the
function returns the input \code{x} without modification. If \code{prob} is
set, a matrix with the number of occurences per class for a given quantile
of the full distribution (e.g. temperature above/below the median). If
\code{threshold} is set, the classes are defined based on the absolute value
(e.g. temperature above/below 13 deg. C). Multiple classes are supported.
}
\examples{
tm <- toymodel()

## convert to tercile forecasts (only display first forecast and obs)
convert2prob(tm$fcst, prob=1:2/3)[1,]
convert2prob(tm$obs, prob=1:2/3)[1,]

## convert to category forecasts (smaller and larger than 1)
convert2prob(tm$fcst, threshold=1)[1,]
convert2prob(tm$obs, threshold=1)[1,]
}
\seealso{
\code{\link{veriApply}}
}
\keyword{utilities}

