% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/earth.R
\name{get_earthtones}
\alias{get_earthtones}
\title{Find the color pallette of a particular place on earth}
\usage{
get_earthtones(latitude = 50.759, longitude = -125.673, zoom = 11,
  number_of_colors = 3, method = "pam", sampleRate = 500,
  include.map = TRUE, ...)
}
\arguments{
\item{latitude}{center of the returned satellite image}

\item{longitude}{center of the returned satellite image}

\item{zoom}{generally this should be between 2 and 20; higher values zoom in closer to the target lat/long; for details see \code{\link{get_map}}}

\item{number_of_colors}{how many colors do you want?}

\item{method}{specifies clustering method. Options are \code{\link{kmeans}} or \code{\link{pam}} (partitioning around medoids)}

\item{sampleRate}{subsampling factor - bigger number = more subsampling and less computation}

\item{include.map}{logical flag that determines whether to return the satelitte image with the data object; for exploring the world leave this as TRUE; if/when you settle on a color scheme and are using this within a visualization, change to FALSE and the function will return a normal R-style color palette.}

\item{...}{additional arguments passed to \code{\link{get_map}}}
}
\description{
Earthtones downloads a satellite image from google earth, translates the image into a perceptually uniform color space, runs one of a few different clustering algorhitms on the colors in the image searching for a user supplied number of colors, and returns the resulting color palette.
}
\details{
Different parts of the world have different color diversity.  Zoom is also especially important.  To visualize the results, simply print the resulting object.
}
\examples{

\dontrun{

get_earthtones(latitude = 24.2, longitude = -77.88, zoom = 11, number_of_colors = 5)
}

}
\seealso{
\code{\link{get_map}}, \code{\link{kmeans}}, \code{\link{pam}}
}

