% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rTMA_import.R
\name{variable.bw.kde}
\alias{variable.bw.kde}
\title{Variable bandwidth Kernel Density Estimation}
\usage{
variable.bw.kde(x, output.domain = x, na.rm = FALSE, adjust.factor = 0.5)
}
\arguments{
\item{x}{A numeric vector of values for estimating density}

\item{output.domain}{The domain of values over which to estimate the
density. Defaults to \code{x}. To use the same domain of \code{x} values
as \R's \code{density}, set to \code{NULL}.}

\item{na.rm}{Remove missing values if TRUE}

\item{adjust.factor}{A scaling factor (exponent) applied to the variable
bandwidth calculation. Larger factors result in greater deviation from the
fixed bandwidth (a value of 0 gives the fixed bandwidth case).}
}
\value{
The kernel density estimate as a \code{density} object, compatible
  with \R's \code{density} function.
}
\description{
Calculates variable bandwidth KDE using Abramson's two stage estimator.
}
\details{
Bandwidth is first calculated using Silverman's estimator, then refined in a
second stage to allow local bandwidth variations in the data based on the
initial estimate.
}
\references{
Abramson, I. S. On Bandwidth Variation in Kernel Estimates-A
  Square Root Law. Ann. Statist. 10, 1217-1223 (1982).
}
\author{
Alexander Lyulph Robert Lubbock, Ian Overton
}
