# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Project a set of points to to set of segments
#'
#' Finds the projection index for a matrix of points \code{x}, when
#' projected onto a set of segments defined by \code{segment_start} and \code{segment_end}.
#'
#' @param x a matrix of data points.
#' @param segment_start a matrix of segment start points.
#' @param segment_end a matrix of segment end points.
#'
#' @return A list with components
#'   \item{x_proj}{a matrix of projections of \code{x} onto the given segments.}
#'   \item{segment}{the index of the segment a point is projected on}
#'   \item{progression}{the progression of a projection along its segment}
#'   \item{distance}{the distance from each point in \code{x} to its projection in \code{x_proj}}
#'
#' @examples
#' x <- matrix(rnorm(50, 0, .5), ncol = 2)
#' segfrom <- matrix(c(0, 1, 0, -1, 1, 0, -1, 0), ncol = 2, byrow = TRUE)
#' segto <- segfrom / 10
#' fit <- project_to_segments(x, segfrom, segto)
#'
#' str(fit) # examine output
#'
#' @export
project_to_segments <- function(x, segment_start, segment_end) {
    .Call('_dynutils_project_to_segments', PACKAGE = 'dynutils', x, segment_start, segment_end)
}

spearman_rank_sparse_rcpp <- function(x, p, nrow) {
    .Call('_dynutils_spearman_rank_sparse_rcpp', PACKAGE = 'dynutils', x, p, nrow)
}

