% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/7_simulation.R
\name{generate_cells}
\alias{generate_cells}
\alias{simulation_default}
\alias{simulation_type_wild_type}
\alias{simulation_type_knockdown}
\title{Simulate the cells}
\usage{
generate_cells(model)

simulation_default(
  burn_time = NULL,
  total_time = NULL,
  ssa_algorithm = ssa_etl(tau = 30/3600),
  census_interval = 4,
  experiment_params = bind_rows(simulation_type_wild_type(num_simulations = 32),
    simulation_type_knockdown(num_simulations = 0)),
  store_reaction_firings = FALSE,
  store_reaction_propensities = FALSE,
  compute_cellwise_grn = FALSE,
  compute_dimred = TRUE,
  compute_rna_velocity = FALSE,
  kinetics_noise_function = kinetics_noise_simple(mean = 1, sd = 0.005)
)

simulation_type_wild_type(
  num_simulations,
  seed = sample.int(10 * num_simulations, num_simulations)
)

simulation_type_knockdown(
  num_simulations,
  timepoint = runif(num_simulations),
  genes = "*",
  num_genes = sample(1:5, num_simulations, replace = TRUE, prob = 0.25^(1:5)),
  multiplier = runif(num_simulations, 0, 1),
  seed = sample.int(10 * num_simulations, num_simulations)
)
}
\arguments{
\item{model}{A dyngen intermediary model for which the gold standard been generated with \code{\link[=generate_gold_standard]{generate_gold_standard()}}.}

\item{burn_time}{The burn in time of the system, used to determine an initial state vector. If \code{NULL}, the burn time will be inferred from the backbone.}

\item{total_time}{The total simulation time of the system. If \code{NULL}, the simulation time will be inferred from the backbone.}

\item{ssa_algorithm}{Which SSA algorithm to use for simulating the cells with \code{\link[GillespieSSA2:ssa]{GillespieSSA2::ssa()}}}

\item{census_interval}{A granularity parameter for the outputted simulation.}

\item{experiment_params}{A tibble generated by rbinding multiple calls of \code{\link[=simulation_type_wild_type]{simulation_type_wild_type()}} and \code{\link[=simulation_type_knockdown]{simulation_type_knockdown()}}.}

\item{store_reaction_firings}{Whether or not to store the number of reaction firings.}

\item{store_reaction_propensities}{Whether or not to store the propensity values of the reactions.}

\item{compute_cellwise_grn}{Whether or not to compute the cellwise GRN activation values.}

\item{compute_dimred}{Whether to perform a dimensionality reduction after simulation.}

\item{compute_rna_velocity}{Whether or not to compute the propensity ratios after simulation.}

\item{kinetics_noise_function}{A function that will generate noise to the kinetics of each simulation.
It takes the \code{feature_info} and \code{feature_network} as input parameters,
modifies them, and returns them as a list. See \code{\link[=kinetics_noise_none]{kinetics_noise_none()}} and \code{\link[=kinetics_noise_simple]{kinetics_noise_simple()}}.}

\item{num_simulations}{The number of simulations to run.}

\item{seed}{A set of seeds for each of the simulations.}

\item{timepoint}{The relative time point of the knockdown}

\item{genes}{Which genes to sample from. \code{"*"} for all genes.}

\item{num_genes}{The number of genes to knockdown.}

\item{multiplier}{The strength of the knockdown. Use 0 for a full knockout, 0<x<1 for a knockdown, and >1 for an overexpression.}
}
\value{
A dyngen model.
}
\description{
\code{\link[=generate_cells]{generate_cells()}} runs simulations in order to determine the gold standard
of the simulations.
\code{\link[=simulation_default]{simulation_default()}} is used to configure parameters pertaining this process.
}
\examples{
library(dplyr)
model <- 
  initialise_model(
    backbone = backbone_bifurcating(),
    simulation = simulation_default(
      ssa_algorithm = ssa_etl(tau = .1),
      experiment_params = bind_rows(
        simulation_type_wild_type(num_simulations = 4),
        simulation_type_knockdown(num_simulations = 4)
      )
    )
  )

\donttest{
model <- model \%>\%
  generate_tf_network() \%>\%
  generate_feature_network() \%>\%
  generate_kinetics() \%>\%
  generate_gold_standard() \%>\%
  generate_cells()
  
plot_simulations(model)
plot_gold_mappings(model)
plot_simulation_expression(model)

model <- model \%>\%
  generate_experiment()
  
dataset <- wrap_dataset(model)
}
}
