% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimred.R, R/dimred_dm_destiny.R,
%   R/dimred_dm_diffusionmap.R, R/dimred_ica.R, R/dimred_knn_fr.R,
%   R/dimred_landmark_mds.R, R/dimred_lle.R, R/dimred_mds.R,
%   R/dimred_mds_isomds.R, R/dimred_mds_sammon.R, R/dimred_mds_smacof.R,
%   R/dimred_pca.R, R/list_dimred_methods.R
\name{dimred}
\alias{dimred}
\alias{dimred_dm_destiny}
\alias{dimred_dm_diffusionmap}
\alias{dimred_ica}
\alias{dimred_knn_fr}
\alias{dimred_landmark_mds}
\alias{dimred_lle}
\alias{dimred_mds}
\alias{dimred_mds_isomds}
\alias{dimred_mds_sammon}
\alias{dimred_mds_smacof}
\alias{dimred_pca}
\alias{list_dimred_methods}
\title{Perform simple dimensionality reduction}
\usage{
dimred(x, method, ndim, ...)

dimred_dm_destiny(
  x,
  ndim = 2,
  distance_method = c("euclidean", "spearman", "cosine")
)

dimred_dm_diffusionmap(
  x,
  ndim = 2,
  distance_method = c("pearson", "spearman", "cosine", "euclidean", "manhattan")
)

dimred_ica(x, ndim = 3)

dimred_knn_fr(
  x,
  lmds_components = 10,
  distance_method = c("pearson", "spearman", "cosine", "euclidean", "manhattan"),
  n_neighbors = 10
)

dimred_landmark_mds(
  x,
  ndim = 2,
  distance_method = c("pearson", "spearman", "cosine", "euclidean", "manhattan")
)

dimred_lle(x, ndim = 3)

dimred_mds(
  x,
  ndim = 2,
  distance_method = c("pearson", "spearman", "cosine", "euclidean", "manhattan")
)

dimred_mds_isomds(
  x,
  ndim = 2,
  distance_method = c("pearson", "spearman", "cosine", "euclidean", "manhattan")
)

dimred_mds_sammon(
  x,
  ndim = 2,
  distance_method = c("pearson", "spearman", "cosine", "euclidean", "manhattan")
)

dimred_mds_smacof(
  x,
  ndim = 2,
  distance_method = c("pearson", "spearman", "cosine", "euclidean", "manhattan")
)

dimred_pca(x, ndim = 2)

list_dimred_methods()
}
\arguments{
\item{x}{Log transformed expression data, with rows as cells and columns as features}

\item{method}{The name of the dimensionality reduction method to use}

\item{ndim}{The number of dimensions}

\item{...}{Any arguments to be passed to the dimensionality reduction method}

\item{distance_method}{The name of the distance metric, see \link[dynutils:calculate_distance]{dynutils::calculate_distance}}

\item{lmds_components}{The number of lmds components to use.
If NULL, LMDS will not be performed first.
If this is a matrix, it is assumed it is a dimred for x.}

\item{n_neighbors}{The size of local neighborhood (in terms of number of neighboring sample points).}
}
\description{
Perform simple dimensionality reduction
}
\examples{
library(Matrix)
x <- abs(Matrix::rsparsematrix(100, 100, .5))
dimred(x, "pca", ndim = 3)
dimred(x, "ica", ndim = 3)

if (interactive()) {
  dimred_dm_destiny(x)
  dimred_dm_diffusionmap(x)
  dimred_ica(x)
  dimred_landmark_mds(x)
  dimred_lle(x)
  dimred_mds(x)
  dimred_mds_isomds(x)
  dimred_mds_sammon(x)
  dimred_mds_smacof(x)
  dimred_pca(x)
  dimred_tsne(x)
  dimred_umap(x)
}

}
