/*
 * Decompiled with CFR 0.152.
 */
package criteres;

import criteres.Info;
import criteres.Qualificatif;
import criteres.Singleton;
import don.DonneeID;
import don.Nominale;
import ihm.IHM;

public class CritereNominale
extends Qualificatif {
    private Nominale m_nominale;

    public CritereNominale(Nominale nominale) {
        this.m_nominale = nominale;
    }

    public Info evaluer(DonneeID obj) {
        int num = this.m_nominale.getNumModalite(obj);
        if (num != -1) {
            return new Singleton(num);
        }
        return new Singleton(Integer.MAX_VALUE);
    }

    public String semantique(Singleton i) {
        if (i.get() < this.m_nominale.getNbModalites() && !i.isError()) {
            return this.m_nominale.getModalites().elementAt(i.get()).getAnnotation();
        }
        return "";
    }

    public int getNbSeries() {
        return this.m_nominale.getNbModalites();
    }

    public String semantique() {
        return String.valueOf(IHM.getXmlLangue().getElement("Cnominale")) + " " + this.m_nominale.getAnnotation();
    }

    public boolean adjectif() {
        return false;
    }
}

