% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{mpp2ddSim}
\alias{mpp2ddSim}
\title{Convert Distribution Name + Parameters to \code{ddSim} Object}
\usage{
mpp2ddSim(distr, parms)
}
\arguments{
\item{distr}{character string giving the name of one of the models fit by
\code{\link{ddFit}}}

\item{parms}{vector of parameters for the \code{distr}, or, alternatively, an array
of parameter sets. Parameterization may follow  either the GLM format or the 
distribution format. For example, the xep01  model (gamma distribution) has
GLM parameters for \code{log(r)} and \code{r}, which are the coefficients of 
the polynomial in the xep01 format (namely, x * exp(b0*log(r) + b1*r)), or 
the gamma distribution parameters, \code{shape} and \code{rate}. The 
elements of parameter vector must be named. For example, 
\code{parms = c(log(r) = -0.373, r = -0.0147)} for the GLM format for an 
xep01 model or, equivalently, \code{parms = c(shape = 1.63, rate = 0.0147)} 
for the distribution format. If  both formats are given, the GLM parameters 
are used and the distribution parameters ignored.}
}
\value{
a ddSim object with \code{srad = NA}
}
\description{
Utility function to format a distribution name and a vector of its parameter values
 to a \code{\link{ddSim}} object for use in the p/d/r/q family of functions
}
