% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.R
\name{write_dua_df}
\alias{write_dua_df}
\title{Write DUA approved data set}
\usage{
write_dua_df(df, file_name, output_type = c("rds", "rdata", "csv", "tsv",
  "delimited", "stata", "sas", "spss"), ...)
}
\arguments{
\item{df}{Data frame object to save.}

\item{file_name}{Name and path for saved file, with or without file
type ending.}

\item{output_type}{Output data file type; options include
\code{rds} (DEFAULT), \code{rdata}, \code{csv}, \code{tsv},
\code{delimited}, \code{stata}, \code{sas}, and \code{spss}.}

\item{...}{Arguments to pass to write function based on the
selected \code{output_type}; see details for more information.}
}
\description{
This function is a wrapper for a variety of write functions that
also checks whether the data set has been cleared for writing based
on the DUA level restrictions chosen by the user. If restricted
variables remain in the data set, the function will return an error
and will not write the data set.
}
\details{
The following output types are supported (with the underlying write
function and default arguments accompanying):

\itemize{
 \item \bold{rds}: \code{saveRDS()}
 \item \bold{rdata}: \code{save()}
 \item \bold{csv}: \code{write.table(...,row.names = FALSE, sep = ,)}
 \item \bold{tsv}: \code{write.table(...,row.names = FALSE, sep = '\\t')}
 \item \bold{delimited}: \code{write.table(...,row.names = FALSE)}
 \item \bold{stata}: \code{haven::write_dta()}
 \item \bold{sas}: \code{haven::write_sas()}
 \item \bold{spss}: \code{haven::write_sav()}
}

All arguments for these internal write functions, including those
with default values, can be modified by adding them to the
top-level \code{write_dua_df()} function.
}
\examples{
## --------------
## Setup
## --------------
## set DUA crosswalk
dua_cw <- system.file('extdata', 'dua_cw.csv', package = 'duawranglr')
set_dua_cw(dua_cw)
## read in data
admin <- system.file('extdata', 'admin_data.csv', package = 'duawranglr')
df <- read_dua_file(admin)
## set restriction level
set_dua_level('level_iii')
## remove restrictive variables
df <- dplyr::select(df, -c(sid,sname,tname))
## --------------

## check restrictions
check_dua_restrictions(df)

## able to write since restrictions check passed
file <- file.path(tempdir(), 'clean_data.csv')
write_dua_df(df, file_name = file, output_type = 'csv')

\dontrun{
 write_dua_df(df, 'clean_data', output_type = 'delimited', sep = '|')
 write_dua_df(df, 'clean_data', output_type = 'stata', version = 11)
}

}
