% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Arithmetic.R
\docType{methods}
\name{Arithmetic}
\alias{Arithmetic}
\alias{+}
\alias{+,dual,missing-method}
\alias{+,dual,numeric-method}
\alias{+,numeric,dual-method}
\alias{+,dual,dual-method}
\alias{-}
\alias{-,dual,missing-method}
\alias{-,dual,numeric-method}
\alias{-,numeric,dual-method}
\alias{-,dual,dual-method}
\alias{*}
\alias{*,dual,numeric-method}
\alias{*,numeric,dual-method}
\alias{*,dual,dual-method}
\alias{/}
\alias{/,dual,numeric-method}
\alias{/,numeric,dual-method}
\alias{/,dual,dual-method}
\alias{^}
\alias{^,dual,numeric-method}
\alias{^,numeric,dual-method}
\alias{^,dual,dual-method}
\title{Arithmetic Operators}
\usage{
\S4method{+}{dual,missing}(e1, e2)

\S4method{+}{dual,numeric}(e1, e2)

\S4method{+}{numeric,dual}(e1, e2)

\S4method{+}{dual,dual}(e1, e2)

\S4method{-}{dual,missing}(e1, e2)

\S4method{-}{dual,numeric}(e1, e2)

\S4method{-}{numeric,dual}(e1, e2)

\S4method{-}{dual,dual}(e1, e2)

\S4method{*}{dual,numeric}(e1, e2)

\S4method{*}{numeric,dual}(e1, e2)

\S4method{*}{dual,dual}(e1, e2)

\S4method{/}{dual,numeric}(e1, e2)

\S4method{/}{numeric,dual}(e1, e2)

\S4method{/}{dual,dual}(e1, e2)

\S4method{^}{dual,numeric}(e1, e2)

\S4method{^}{numeric,dual}(e1, e2)

\S4method{^}{dual,dual}(e1, e2)
}
\arguments{
\item{e1}{dual object or numeric value.}

\item{e2}{dual object or numeric value.}
}
\value{
The correspondent values of the arithmetic operation on \code{e1} and \code{e2} is returned.
}
\description{
These unary and binary operators perform arithmetic on dual objects.
}
\examples{
x <- dual(1.5, 1:0)
y <- dual(2.6, 0:1)
+x
-x
x - y
x * y
x / y
x ^ y
x + y
}
