% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/applied_titecrm.R
\name{applied_titecrm}
\alias{applied_titecrm}
\title{Execute the TITE-CRM}
\usage{
applied_titecrm(prior, target, tox, level, followup, obswin,
    no_skip_esc = TRUE, no_skip_deesc = TRUE, global_coherent_esc = TRUE,
    stop_func = NULL, ...)
}
\arguments{
\item{prior}{A vector of prior estimates of toxicity probabilties for the
dose levels.}

\item{target}{The target DLT rate.}

\item{tox}{A vector of subject outcomes; 1 indicates toxicity, 0 otherwise.}

\item{level}{A vector of dose levels assigned to subjects. The length of
level must be equal to that of tox.}

\item{followup}{A vector of follow up times of subjects. The length must be equal
to that of tox.}

\item{obswin}{The observation period with respect to which DLT is assessed.}

\item{no_skip_esc}{If FALSE, the method will not enforce no skipping of doses
in escalation. Default is TRUE.}

\item{no_skip_deesc}{If FALSE, the method will not enforce no skipping of
doses in de-escalation. Default is TRUE.}

\item{global_coherent_esc}{If FALSE, the method will not enforce global
coherent escalation, that is, escalation if the overall rate of toxicity
seen at the current dose level is above the target rate. Default is TRUE.}

\item{stop_func}{An optional argument to provide a function which will
utilised alongside the TITE-CRM to determine if the trial should be stopped.}

\item{...}{Any other arguments detailed in dfcrm::titecrm.}
}
\value{
An object of class "mtd" is returned as per package "dfcrm",
    additional information is provided if a stopping function is used.

\item{prior}{Initial guesses of toxicity rates.}  \item{target}{The target
probability of toxicity at the MTD.}  \item{ptox}{Updated estimates of
toxicity rates.}  \item{ptoxL}{Lower confidence/probability limits of
toxicity rates.}  \item{ptoxU}{Upper confidence/probability limits of
toxicity rates.}  \item{mtd}{The updated estimate of the MTD.}
\item{prior.var}{The variance of the normal prior.}  \item{post.var}{The
posterior variance of the model parameter.}  \item{estimate}{Estimate of the
model parameter.}  \item{method}{The method of estimation.}  \item{model}{The
working model.}  \item{dosescaled}{The scaled doses obtained via backward
substitution.}  \item{tox}{subjects' toxicity indications.}
\item{level}{Dose levels assigned to subjects.}  \item{followup}{Follow-up
times of subjects.}  \item{obswin}{Observation window with respect to which
DLT is assessed.}  \item{weights}{Weights assigned to subjects.}
\item{entry}{Entry times of subjects.}  \item{exit}{Exit times of subjects.}
\item{scheme}{Weighting scheme.}  \item{stop}{A logical variable detailing if
the trial should be stopped; TRUE to stop, FALSE otherwise}
\item{stop_reason}{A detailed reason for why the trial should be
stopped. Only provided if stop is TRUE}
}
\description{
applied_titecrm is used to execute the time-to-event continual
    reassessment method with specified design options to determine the dose
    for the next subject.
}
\details{
The adaptive weighting scheme is given in Cheung and Chappell (2000)
    given in the reference list.
}
\examples{
prior    <- c(0.1, 0.3, 0.5)
target   <- 0.2
tox      <- c(0, 0, 1, 0, 1, 1)
level    <- c(1, 1, 1, 2, 2, 2)
followup <- c(96, 82, 77, 60, 51, 44)
obswin   <- 80

applied_titecrm(prior = prior, target = target, tox = tox,level = level,
                followup = followup, obswin = obswin)

}
\references{
O'Quigley, J. O., Pepe, M., and Fisher, L. (1990). Continual
    reassessment method: A practical design for phase I clinical trials in
    cancer. Biometrics 46:33-48.

Cheung, Y. K. (2011). Dose Finding by the Continual Reassessment Method. New
York: Chapman & Hall/CRC Press.

Cheung, Y. K. and Chappell, R. (2000). Sequential designs for phase I
clinical trials with late-onset toxicities. Biometrics 56:1177-1182.
}
\keyword{CRM}
\keyword{TITE}
