% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsmodel.R
\name{colorVector}
\alias{colorVector}
\title{Set Color Vector From Parameters}
\usage{
colorVector(col, image, iters)
}
\arguments{
\item{col}{A vector or list of colors}

\item{image}{A vector or list of colors}

\item{iters}{A number indicating the number of iterations desired.
If set to greater than 1, \code{iters} becomes the length of the output.}
}
\description{
Outputs a color vector.
If the combined length of \code{col} and \code{image} is  2, and \code{iters} is greather than 1,
this function creates a gradient from first specified color to the second. The length of said
vector will be equal to \code{iters}.
If the combined length of \code{col} and \code{image} is greater than two, then the output will
be a vector of whatever was input into \code{col} and \code{image} with output length being
\code{min(length(col) + length(image), iters)}.
}
\keyword{internal}

