% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{distributions}
\alias{distributions}
\title{Distributions for a range of positions between <start> and <end>}
\usage{
distributions(
  x,
  start = 1,
  end = NULL,
  step = NULL,
  output_file = NULL,
  plot = FALSE,
  ncpu = 2
)
}
\arguments{
\item{x}{An object of class \code{dmm}}

\item{start}{Start position :  a positive integer giving the start position along the sequence from which the distributions of the DMM should be computed}

\item{end}{End position :  a positive integer giving the end position along the sequence until which the distributions of the DMM should be computed}

\item{step}{A step (integer)}

\item{output_file}{(Optional) A file containing matrix of distributions (e.g, "C:/.../DIST.txt")}

\item{plot}{\code{FALSE} (default); \code{TRUE} (display a figure plot of distribution probabilities by position)}

\item{ncpu}{Default=2. Represents the number of cores used to parallelized computation. If ncpu=-1, then it uses all available cores.}
}
\value{
A matrix with positions and distributions of states
}
\description{
Distributions for a range of positions between <start> and <end>
}
\examples{
\donttest{
data(lambda, package = "drimmR")
dmm <- fitdmm(lambda, 1, 1, c('a','c','g','t'), init.estim = "freq", fit.method="sum")
distributions(dmm,start=1,end=1000,step=100, plot=TRUE)
}
}
\references{
\insertRef{BaVe2018}{drimmR}
\insertRef{Ver08}{drimmR}
}
\seealso{
\link[drimmR]{fitdmm}, \link[drimmR]{getDistribution}, \link[drimmR]{getStationaryLaw}
}
\author{
Alexandre Seiller
}
