% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamic.R
\name{get_trace}
\alias{get_trace}
\title{Get a trace of a dynamic target's value.}
\usage{
get_trace(trace, value)
}
\arguments{
\item{trace}{Character, name of the trace
you want to extract. Such trace names are declared
in the \code{.trace} argument of \code{map()}, \code{cross()} or \code{group()}.}

\item{value}{The return value of the target with the trace.}
}
\value{
The dynamic trace of one target in another:
a vector of values from a grouping variable.
}
\description{
Get the dynamic trace of a target's value.
Best used inside a \code{drake} plan.
}
\details{
In dynamic branching, the trace keeps track
of how the sub-targets were generated.
It reminds us the values of grouping variables
that go with individual sub-targets.
}
\examples{
\dontrun{
isolate_example("demonstrate dynamic trace", {
plan <- drake_plan(
  w = LETTERS[seq_len(3)],
  x = letters[seq_len(2)],

  # The first trace lets us see the values of w
  # that go with the sub-targets of y.
  y = target(c(w, x), dynamic = cross(w, x, .trace = w)),

  # We can use the trace as a grouping variable for the next
  # group().
  w_tr = get_trace("w", y),

  # Now, we use the trace again to keep track of the
  # values of w corresponding to the sub-targets of z.
  z = target(y, dynamic = group(y, .by = w_tr, .trace = w_tr))
)
make(plan)

# We can read the trace outside make().
read_trace("w", "y")
read_trace("w_tr", "z")
})
}
}
\seealso{
\code{\link[=read_trace]{read_trace()}}, \code{\link[=subtargets]{subtargets()}}
}
