% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drake_plan_helpers.R
\name{cross}
\alias{cross}
\title{Define a target for each combination of values
\lifecycle{maturing}}
\usage{
cross(..., .data, .id, .tag_in, .tag_out)
}
\arguments{
\item{...}{Grouping variables. New grouping variables must be
supplied with their names and values, existing grouping variables
can be given as symbols without any values assigned.}

\item{.data}{A data frame of new grouping variables with
grouping variable names as column names and values as elements.}

\item{.id}{Symbol or vector of symbols naming grouping variables
to incorporate into target names. Useful for creating short target
names. Set \code{.id = FALSE} to use integer indices as target name suffixes.}

\item{.tag_in}{A symbol or vector of symbols. Tags assign targets
to grouping variables. Use \code{.tag_in} to assign \emph{untransformed}
targets to grouping variables.}

\item{.tag_out}{Just like \code{.tag_in}, except that \code{.tag_out}
assigns \emph{transformed} targets to grouping variables.}
}
\description{
Similar \code{crossing()}, from \code{tidyr}, except it
defines new targets in \code{drake}.
}
\details{
Only valid within a call to \code{\link[=target]{target()}} in
\code{\link[=drake_plan]{drake_plan()}}. See the examples below.
}
\section{Keywords}{

\code{\link[=drake_plan]{drake_plan()}} understands special keyword functions for your commands.
With the exception of \code{\link[=target]{target()}}, each one is a proper function
with its own help file.
\itemize{
\item \code{\link[=target]{target()}}: give the target more than just a command.
Using \code{\link[=target]{target()}}, you can apply a transformation
(examples: \url{https://ropenscilabs.github.io/drake-manual/plans.html#large-plans}), # nolint
supply a trigger (\url{https://ropenscilabs.github.io/drake-manual/triggers.html}), # nolint
or set any number of custom columns.
\item \code{\link[=map]{map()}}: create multiple targets. Called inside \code{\link[=target]{target()}}.
\item \code{\link[=split]{split()}}: create a target for each subset of data.
Called inside \code{\link[=target]{target()}}.
\item \code{\link[=cross]{cross()}}: create a target for each combination of values.
Called inside \code{\link[=target]{target()}}.
\item \code{\link[=combine]{combine()}}: aggregate groups of targets into other targets.
Called inside \code{\link[=target]{target()}}.
\item \code{\link[=file_in]{file_in()}}: declare an input file dependency.
\item \code{\link[=file_out]{file_out()}}: declare an output file to be produced
when the target is built.
\item \code{\link[=knitr_in]{knitr_in()}}: declare a \code{knitr} file dependency such as an
R Markdown (\code{*.Rmd}) or R LaTeX (\code{*.Rnw}) file.
\item \code{\link[=ignore]{ignore()}}: force \code{drake} to entirely ignore a piece of code:
do not track it for changes and do not analyze it for dependencies.
\item \code{\link[=no_deps]{no_deps()}}: tell \code{drake} to not track the dependencies
of a piece of code. \code{drake} still tracks the code itself for changes.
\item \code{\link[=drake_envir]{drake_envir()}}: get the environment where drake builds targets.
Intended for advanced custom memory management.
}
}

\examples{
models <- c("glm", "hierarchical")
plan <- drake_plan(
  data = target(
    get_data(x),
    transform = map(x = c("simulated", "survey"))
  ),
  analysis = target(
    analyze_data(data, model),
    transform = cross(data, model = !!models, .id = c(x, model))
  ),
  summary = target(
    summarize_analysis(analysis),
    transform = map(analysis, .id = c(x, model))
  ),
  results = target(
    bind_rows(summary),
    transform = combine(summary, .by = data)
  )
)
plan
if (requireNamespace("styler", quietly = TRUE)) {
  print(drake_plan_source(plan))
}
}
\seealso{
map, split, combine, drake_plan, target
}
