% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-cache.R
\name{get_cache}
\alias{get_cache}
\title{Get the default cache of a \code{drake} project.}
\usage{
get_cache(path = getwd(), search = TRUE, verbose = 1L,
  force = FALSE, fetch_cache = NULL, console_log_file = NULL)
}
\arguments{
\item{path}{Character, either the root file path of a \code{drake} project
or a folder containing the root (top-level working directory
where you plan to call \code{\link[=make]{make()}}).
If this is too confusing, feel free to just use \code{storr::storr_rds()}
to get the cache.
If \code{search = FALSE}, \code{path} must be the root.
If \code{search = TRUE}, you can specify any
subdirectory of the project. Let's say \code{"/home/you/my_project"}
is the root. The following are equivalent and correct:
\itemize{
\item \code{get_cache(path = "/home/you/my_project", search = FALSE)}
\item \code{get_cache(path = "/home/you/my_project", search = TRUE)}
\item \code{get_cache(path = "/home/you/my_project/subdir/x", search = TRUE)}
\item \code{get_cache(path = "/home/you/my_project/.drake", search = TRUE)}
\item \code{get_cache(path = "/home/you/my_project/.drake/keys", search = TRUE)}
}}

\item{search}{Logical. If \code{TRUE}, search parent directories
to find the nearest drake cache. Otherwise, look in the
current working directory only.
Ignored if a \code{cache} is supplied.}

\item{verbose}{Integer, control printing to the console/terminal.
\itemize{
\item \code{0}: print nothing.
\item \code{1}: print targets, retries, and failures.
\item \code{2}: also show a spinner when preprocessing tasks are underway.
}}

\item{force}{Deprecated.}

\item{fetch_cache}{Deprecated.}

\item{console_log_file}{Optional character scalar of a file name or
connection object (such as \code{stdout()}) to dump maximally verbose
log information for \code{\link[=make]{make()}}. Independent of the \code{verbose} argument.}
}
\value{
A drake/storr cache in a folder called \code{.drake/},
if available. \code{NULL} otherwise.
}
\description{
Only works if the cache
is in a folder called \code{.drake/}. See the description of the
\code{path} argument for details.
}
\examples{
\dontrun{
isolate_example("Quarantine side effects.", {
if (suppressWarnings(require("knitr"))) {
clean(destroy = TRUE)
# No cache is available.
get_cache() # NULL
load_mtcars_example() # Get the code with drake_example("mtcars").
make(my_plan) # Run the project, build the targets.
x <- get_cache() # Now, there is a cache.
y <- storr::storr_rds(".drake") # Equivalent.
# List the objects readable from the cache with readd().
x$list()
}
})
}
}
\seealso{
\code{\link[=new_cache]{new_cache()}}, \code{\link[=drake_config]{drake_config()}}
}
