% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-graphinfo.R
\name{legend_nodes}
\alias{legend_nodes}
\title{Create the nodes data frame used in the legend
of the graph visualizations.}
\usage{
legend_nodes(font_size = 20)
}
\arguments{
\item{font_size}{Font size of the node label text.}
}
\value{
A data frame of legend nodes for the graph visualizations.
}
\description{
Output a \code{visNetwork}-friendly
data frame of nodes. It tells you what
the colors and shapes mean
in the graph visualizations.
}
\examples{
\dontrun{
# Show the legend nodes used in graph visualizations.
# For example, you may want to inspect the color palette more closely.
if (requireNamespace("visNetwork", quietly = TRUE)) {
visNetwork::visNetwork(nodes = legend_nodes()) # nolint
}
}
}
