% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wildcards.R
\name{expand_plan}
\alias{expand_plan}
\title{Create replicates of targets.}
\usage{
expand_plan(plan, values = NULL, rename = TRUE, sep = "_")
}
\arguments{
\item{plan}{workflow plan data frame}

\item{values}{values to expand over. These will be appended to
the names of the new targets.}

\item{rename}{logical, whether to rename the targets
based on the \code{values}. See the examples for a demo.}

\item{sep}{character scalar, delimiter between the original
target names and the values to append to create the new
target names. Only relevant when \code{rename} is \code{TRUE}.}
}
\value{
An expanded workflow plan data frame (with replicated targets).
}
\description{
Duplicates the rows of a workflow plan data frame.
Prefixes are appended to the new target names
so targets still have unique names.
}
\examples{
# Create the part of the workflow plan for the datasets.
datasets <- drake_plan(
  small = simulate(5),
  large = simulate(50))
# Create replicates. If you want repeat targets,
# this is convenient.
expand_plan(datasets, values = c("rep1", "rep2", "rep3"))
# Choose whether to rename the targets based on the values.
expand_plan(datasets, values = 1:3, rename = TRUE)
expand_plan(datasets, values = 1:3, rename = FALSE)
}
\seealso{
\code{\link[=drake_plan]{drake_plan()}}, \code{\link[=map_plan]{map_plan()}}, \code{\link[=reduce_by]{reduce_by()}}, \code{\link[=gather_by]{gather_by()}}, \code{\link[=reduce_plan]{reduce_plan()}},
\code{\link[=gather_plan]{gather_plan()}}, \code{\link[=evaluate_plan]{evaluate_plan()}}, \code{\link[=expand_plan]{expand_plan()}}
}
