% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drake_plan.R
\name{file_out}
\alias{file_out}
\title{Declare the file outputs of a workflow plan command.}
\usage{
file_out(...)
}
\arguments{
\item{...}{Character vector of output file paths.}
}
\value{
A character vector of declared output file paths.
}
\description{
Use this function to help write the commands
in your workflow plan data frame. You can only specify
one file output per command. See the examples
for a full explanation.
}
\examples{
\dontrun{
test_with_dir("Contain side effects", {
# The `file_out()` and `file_in()` functions
# just takes in strings and returns them.
file_out("summaries.txt", "output.csv")
# Their main purpose is to orchestrate your custom files
# in your workflow plan data frame.
suppressWarnings(
  plan <- drake_plan(
    write.csv(mtcars, file_out("mtcars.csv")),
    contents = read.csv(file_in("mtcars.csv")),
    strings_in_dots = "literals" # deprecated but useful: no single quotes needed. # nolint
  )
)
plan
# Drake knows "\\"mtcars.csv\\"" is the first target
# and a dependency of `contents`. See for yourself:
make(plan)
file.exists("mtcars.csv")
# See also `knitr_in()`. `knitr_in()` is like `file_in()`
# except that it analyzes active code chunks in your `knitr`
# source file and detects non-file dependencies.
# That way, updates to the right dependencies trigger rebuilds
# in your report.
})
}
}
\seealso{
\code{\link[=file_in]{file_in()}}, \code{\link[=knitr_in]{knitr_in()}}, \code{\link[=ignore]{ignore()}}
}
