% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workplan.R
\name{target}
\alias{target}
\title{Define custom columns in a \code{\link[=drake_plan]{drake_plan()}}.}
\usage{
target(...)
}
\arguments{
\item{...}{named arguments specifying fields of the workflow plan.
Tidy evaluation will be applied to them, so the \code{!!} operator
is evaluated immediately for expressions and language objects.}
}
\value{
A one-row workflow plan data frame with the named
arguments as columns.
}
\description{
The \code{target()} function lets you define
custom columns in a workflow plan data frame, both
inside and outside calls to \code{\link[=drake_plan]{drake_plan()}}.
}
\examples{
# Use target() to create your own custom columns in a drake plan.
# See ?triggers for more on triggers.
plan <- drake_plan(
  website_data = target(
    command = download_data("www.your_url.com"),
    trigger = "always",
    custom_column = 5
  ),
  analysis = analyze(website_data),
  strings_in_dots = "literals"
)
plan
# make(plan) # nolint
# Call target() inside or outside drake_plan().
target(
  command = download_data("www.your_url.com"),
  trigger = "always",
  custom_column = 5
)
}
\seealso{
\code{\link[=drake_plan]{drake_plan()}}, \code{\link[=make]{make()}}
}
