% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dependencies.R
\name{tracked}
\alias{tracked}
\title{List the targets and imports
that are reproducibly tracked.}
\usage{
tracked(plan = drake_plan(), targets = drake::possible_targets(plan),
  envir = parent.frame(), jobs = 1, verbose = TRUE)
}
\arguments{
\item{plan}{workflow plan data frame, same as for function
\code{\link{make}()}.}

\item{targets}{names of targets to build, same as for function
\code{\link{make}()}.}

\item{envir}{environment to import from, same as for function
\code{\link{make}()}.}

\item{jobs}{number of jobs to accelerate the construction
of the dependency graph. A light \code{mclapply}-based
parallelism is used if your operating system is not Windows.}

\item{verbose}{logical, whether to print
progress messages to the console.}
}
\value{
A character vector with the names of reproducibly-tracked targets.
}
\description{
In other words, list all the nodes
in your project's dependency network.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
load_basic_example() # Load the canonical example for drake.
# List all the targets/imports that are reproducibly tracked.
tracked(my_plan)
})
}
}
