% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{read_drake_plan}
\alias{read_drake_plan}
\title{Read the workflow plan
from your last attempted call to \code{\link{make}()}.}
\usage{
read_drake_plan(path = getwd(), search = TRUE, cache = NULL,
  verbose = TRUE)
}
\arguments{
\item{path}{Root directory of the drake project,
or if \code{search} is \code{TRUE}, either the
project root or a subdirectory of the project.}

\item{search}{logical. If \code{TRUE}, search parent directories
to find the nearest drake cache. Otherwise, look in the
current working directory only.}

\item{cache}{optional drake cache. See code{\link{new_cache}()}.
If \code{cache} is supplied,
the \code{path} and \code{search} arguments are ignored.}

\item{verbose}{whether to print console messages}
}
\value{
A workflow plan data frame.
}
\description{
Uses the cache.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
load_basic_example() # Get the code with drake_example("basic").
make(my_plan) # Run the project, build the targets.
read_drake_plan() # Retrieve the workflow plan data frame from the cache.
})
}
}
\seealso{
\code{\link{read_drake_config}}
}
