% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{read_drake_config}
\alias{read_drake_config}
\title{Read the cached \code{\link{drake_config}()}
list from the last \code{\link{make}()}.}
\usage{
read_drake_config(path = getwd(), search = TRUE, cache = NULL,
  verbose = 1, jobs = 1, envir = parent.frame())
}
\arguments{
\item{path}{Root directory of the drake project,
or if \code{search} is \code{TRUE}, either the
project root or a subdirectory of the project.}

\item{search}{logical. If \code{TRUE}, search parent directories
to find the nearest drake cache. Otherwise, look in the
current working directory only.}

\item{cache}{optional drake cache. See code{\link{new_cache}()}.
If \code{cache} is supplied,
the \code{path} and \code{search} arguments are ignored.}

\item{verbose}{whether to print console messages}

\item{jobs}{number of jobs for light parallelism.
Supports 1 job only on Windows.}

\item{envir}{Optional environment to fill in if
\code{config$envir} was not cached. Defaults to your workspace.}
}
\value{
The cached master internal configuration list
of the last \code{\link{make}()}.
}
\description{
See \code{\link{drake_config}()} for more information
about drake's internal runtime configuration parameter list.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
load_basic_example() # Get the code with drake_example("basic").
make(my_plan) # Run the project, build the targets.
# Retrieve the master internal configuration list from the cache.
read_drake_config()
})
}
}
\seealso{
\code{\link{make}}
}
