% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.R
\name{drake_config}
\alias{drake_config}
\title{Create the internal runtime parameter list
used internally in \code{\link{make}()}.}
\usage{
drake_config(plan = drake_plan(), targets = drake::possible_targets(plan),
  envir = parent.frame(), verbose = 1, hook = default_hook,
  cache = drake::get_cache(verbose = verbose, force = force),
  fetch_cache = NULL, parallelism = drake::default_parallelism(),
  jobs = 1, packages = rev(.packages()), prework = character(0),
  prepend = character(0), command = drake::default_Makefile_command(),
  args = drake::default_Makefile_args(jobs = jobs, verbose = verbose),
  recipe_command = drake::default_recipe_command(), timeout = Inf,
  cpu = timeout, elapsed = timeout, retries = 0, force = FALSE,
  log_progress = FALSE, graph = NULL, trigger = drake::default_trigger(),
  imports_only = FALSE, skip_imports = FALSE, skip_safety_checks = FALSE,
  lazy_load = FALSE, session_info = TRUE, cache_log_file = NULL)
}
\arguments{
\item{plan}{same as for \code{\link{make}}}

\item{targets}{same as for \code{\link{make}}}

\item{envir}{same as for \code{\link{make}}}

\item{verbose}{same as for \code{\link{make}}}

\item{hook}{same as for \code{\link{make}}}

\item{cache}{same as for \code{\link{make}}}

\item{fetch_cache}{same as for \code{\link{make}}}

\item{parallelism}{same as for \code{\link{make}}}

\item{jobs}{same as for \code{\link{make}}}

\item{packages}{same as for \code{\link{make}}}

\item{prework}{same as for \code{\link{make}}}

\item{prepend}{same as for \code{\link{make}}}

\item{command}{same as for \code{\link{make}}}

\item{args}{same as for \code{\link{make}}}

\item{recipe_command}{same as for \code{\link{make}}}

\item{timeout}{same as for \code{\link{make}}}

\item{cpu}{same as for \code{\link{make}}}

\item{elapsed}{same as for \code{\link{make}}}

\item{retries}{same as for \code{\link{make}}}

\item{force}{same as for \code{\link{make}}}

\item{log_progress}{logical, whether to clear
the cached progress of the targets readable by}

\item{graph}{igraph object representing the workflow plan network.
Overrides \code{skip_imports}.}

\item{trigger}{same as for \code{\link{make}}}

\item{imports_only}{logical, whether to skip building the targets
in \code{plan} and just import objects and files.}

\item{skip_imports}{logical, whether to totally neglect to
process the imports and jump straight to the targets. This can be useful
if your imports are massive and you just want to test your project,
but it is bad practice for reproducible data analysis.
This argument is overridden if you supply your own \code{graph} argument.}

\item{skip_safety_checks}{logical, whether to skip the safety checks
on your workflow to save time. Use at your own peril.}

\item{lazy_load}{same as for \code{\link{make}}}

\item{session_info}{same as for \code{\link{make}}}

\item{cache_log_file}{same as for \code{\link{make}}}
}
\value{
The master internal configuration list of a project.
}
\description{
This configuration list
is also required for functions such as \code{\link{outdated}()} and
\code{\link{vis_drake_graph}()}. It is meant to be specific to
a single call to \code{\link{make}()}, and you should not modify
it by hand afterwards. If you later plan to call \code{\link{make}()}
with different arguments (especially \code{targets}),
you should refresh the config list with another call to
\code{\link{drake_config}()}. For changes to the
\code{targets} argument
specifically, it is important to recompute the config list
to make sure the internal workflow network has all the targets you need.
Modifying the \code{targets} element afterwards will have no effect
and it could lead to false negative results from
\code{\link{outdated}()}
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
load_basic_example() # Get the code with drake_example("basic").
# Construct the master internal configuration list.
con <- drake_config(my_plan)
# These functions are faster than otherwise
# because they use the configuration list.
outdated(config = con) # Which targets are out of date?
missed(config = con) # Which imports are missing?
# In make(..., jobs = n), it would be silly to set `n` higher than this:
max_useful_jobs(config = con)
# Show a visNetwork graph
vis_drake_graph(config = con)
# Get the underlying node/edge data frames of the graph.
dataframes_graph(config = con)
})
}
}
\seealso{
\code{\link{make_with_config}}, \code{\link{make}},
\code{\link{drake_plan}}, \code{\link{vis_drake_graph}}
}
