% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddpcRquant.R
\name{ddpcRquant}
\alias{ddpcRquant}
\title{Quantify droplets}
\usage{
ddpcRquant(path, threshold.int = 0.9995, reps = 10, blocks = 150,
  threshold.manual = NULL)
}
\arguments{
\item{path}{\code{character} path to diectory with raw data.}

\item{threshold.int}{\code{numeric} probability of the threshold quantile.}

\item{reps}{\code{numeric} vector representing the number of replications.}

\item{blocks}{\code{numeric} vector representing the number of blocks.}

\item{threshold.manual}{if \code{numeric}, the value is used as the threshold. If 
\code{NULL}, the threshold is calculated automatically.}
}
\value{
\code{\linkS4class{dpcr}} object.
}
\description{
Cluster raw data from QX100 and QX200 systems.
}
\note{
This function is a modification of code was implemented using the code found on
\url{http://www.ddpcrquant.ugent.be/}.
}
\author{
Wim Trypsteen, Matthijs Vynck, Jan De Neve, Pawel Bonczkowski, Maja Kiselinova, 
Eva Malatinkova, Karen Vervisch, Olivier Thas, Linos Vandekerckhove, Ward De Spiegelaere.
}
\references{
Trypsteen W, Vynck M, De Neve J, Bonczkowski P, Kiselinova M, 
Malatinkova E, Vervisch K, Thas O, Vandekerckhove L, De Spiegelaere W, 
\emph{ddpcRquant: Threshold Determination for Single Channel Droplet Digital PCR 
Experiments}. Analytical and Bioanalytical Chemistry 2015. 407(19): p.5827-34.
}

