% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/qpcr_analyser.R
\docType{methods}
\name{qpcr_analyser}
\alias{qpcr_analyser}
\alias{qpcr_analyser,adpcr-method}
\alias{qpcr_analyser,data.frame-method}
\alias{qpcr_analyser,modlist-method}
\alias{qpcr_analyser-methods}
\title{qPCR Analyser}
\arguments{
\item{input}{a dataframe containing the qPCR data or a result of function
\code{\link[qpcR]{modlist}} or an object of the class
\code{\linkS4class{adpcr}}.}

\item{cyc}{the column containing the cycle data. Defaults to first column.}

\item{fluo}{the column(s) (runs) to be analyzed. If NULL, all runs will be
considered.  Use fluo = 2 to chose the second column for example.}

\item{model}{is the model to be used for the analysis for all runs. Defaults
to 'l5' (see \code{\link[qpcR]{pcrfit}}).}

\item{norm}{logical. Indicates if the raw data should be normalized within
[0, 1] before model fitting.}

\item{iter_tr}{\code{iter_tr} number of iteration to fit the curve.}

\item{type}{is the method for the crossing point/threshold cycle estimation
and efficiency estimation (\link[qpcR]{efficiency}). Defaults to 'Cy0'
(\code{\link[qpcR]{Cy0}}).}

\item{takeoff}{logical; if \code{TRUE} calculates the first significant
cycle of the exponential region (takeoff point). See
\code{\link[qpcR]{takeoff}} for details.}
}
\value{
A matrix where each column represents crossing point, efficiency,
the raw fluorescence value at the point defined by type and difference
between minimum and maximum of observed fluorescence. If takeoff parameter
is \code{TRUE}, additional two column represents start and the end of the
fluorescence growth.
}
\description{
Calculate statistics based on fluorescence. The function can be used to
analyze amplification curve data from quantitative real-time PCR
experiments. The analysis includes the fitting of the amplification curve by
a non-linear function and the calculation of a quantification point (often
referred to as Cp (crossing-point), Cq or Ct) based on a user defined
method. The function can be used to analyze data from chamber based dPCR
machines.
}
\details{
The \code{qpcRanalyzer} is a functions to automatize the analysis of
amplification curves from conventional quantitative real-time PCR (qPCR)
experiments and is adapted for the needs in dPCR.  This function calls
instances of the the \code{qpcR} package to calculate the quantification
points (cpD1, cpD2, Cy0 (default), TOP (optional)), the amplification
efficiency, fluorescence at the quantification point (Cq), the absolute
change of fluorescence and the take-off point (TOP). Most of the central
functionality of the \code{qpcR} package is accessible. The user can assign
concentrations to the samples. One column contains binary converted (pos (1)
and neg (0)) results for the amplification reaction based on a user defined
criteria (Cq-range, fluorescence cut-off, ...). \code{qpcr_analyser} tries
to detect cases where an amplification did not take place of was impossible
to analyze. By default \code{qpcr_analyser} analyses uses the Cy0 as
described in Guescini et al. (2008) for estimation of the quantification
point since method is considered to be better suited for many probe systems.
By default a 5-parameter model is used to fit the amplification curves. As
such \code{qpcr_analyser} is a function, which serves for preliminary data
inspection (see Example section) and as input for other R functions from the
\code{dpcR} package (e.g., \link{plot_panel}).
}
\examples{
# Take data of guescini1 data set from the qpcR R package.
library(qpcR)
# Use the first column containing the cycles and the second column for sample F1.1.
data(guescini1)
qpcr_analyser(guescini1, cyc = 1, fluo = 2)

# Use similar setting as before but set takeoff to true for an estimation of
# the first significant cycle of the exponential region.
qpcr_analyser(guescini1, cyc = 1, fluo = 2, takeoff = TRUE)

# Use similar setting as before but use qpcr_analyser in a loop to calculate the results for the
# first four columns containing the fluorescence in guescini1
print(qpcr_analyser(guescini1, cyc = 1, fluo = 2:5, takeoff = TRUE))

# Run qpcr_analyser on the list of models (finer control on fitting model process)
models <- modlist(guescini1)
qpcr_analyser(models)
}
\author{
Stefan Roediger, Andrej-Nikolai Spiess, Michal Burdukiewicz.
}
\references{
Ritz C, Spiess An-N, \emph{qpcR: an R package for sigmoidal
model selection in quantitative real-time polymerase chain reaction
analysis}.  Bioinformatics 24 (13), 2008.

Andrej-Nikolai Spiess (2013). qpcR: Modelling and analysis of real-time PCR
data.\cr \url{http://CRAN.R-project.org/package=qpcR}\cr
}
\seealso{
\link[qpcR]{modlist}.
}
\keyword{Cy0}
\keyword{amplification}
\keyword{qPCR}
\keyword{quantification}
\keyword{real-time}

