% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visGSEA.r
\name{visGSEA}
\alias{visGSEA}
\title{Function to visualise running enrichment score for a given sample and a gene set}
\usage{
visGSEA(
eTerm,
which_sample = 1,
which_term = "GO:0006281",
plot = T,
orientation = c("vertical", "horizontal"),
hit.linewidth = 0.5,
newpage = T
)
}
\arguments{
\item{eTerm}{an object of class "eTerm"}

\item{which_sample}{which sample will be used. It can be index or
sample names}

\item{which_term}{which term will be used. It can be index or term ID
or term names}

\item{plot}{logical to indicate whether to plot}

\item{orientation}{the orientation of the plots. It can be either
"vertical" (default) or "horizontal"}

\item{hit.linewidth}{the line width for the hits (ie genes in the gene
set)}

\item{newpage}{logical to indicate whether to open a new page. By
default, it sets to true for opening a new page}
}
\value{
leading genes (being sorted)
}
\description{
\code{visGSEA} is supposed to visualise running enrichment score for a
given sample and a gene set. To help understand the underlying running
enrichment score, the input gene scores are also displayed. Positions
for members in the given gene set are color-coded in both displays (red
line for the positive gene scores, and green line for the negative).
}
\note{
none
}
\examples{
#visGSEA(eTerm, which_sample=1, which_term=1)
}
\seealso{
\code{\link{dGSEA}}, \code{\link{dGSEAview}}
}
