% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.R
\name{transformation_paged_report}
\alias{transformation_paged_report}
\title{Reporting the information of transformation}
\usage{
transformation_paged_report(
  .data,
  target = NULL,
  output_format = c("pdf", "html"),
  output_file = NULL,
  output_dir = tempdir(),
  browse = TRUE,
  title = "Transformation Report",
  subtitle = deparse(substitute(.data)),
  author = "dlookr",
  abstract_title = "Report Overview",
  abstract = NULL,
  title_color = "white",
  subtitle_color = "tomato1",
  cover_img = NULL,
  create_date = Sys.time(),
  logo_img = NULL,
  theme = c("orange", "blue"),
  sample_percent = 100,
  base_family = NULL,
  ...
)
}
\arguments{
\item{.data}{a data.frame or a \code{\link{tbl_df}}.}

\item{target}{character. target variable.}

\item{output_format}{report output type. Choose either "pdf" and "html".
"pdf" create pdf file by rmarkdown::render() and pagedown::chrome_print(). so, 
you needed Chrome web browser on computer.  
"html" create html file by rmarkdown::render().}

\item{output_file}{name of generated file. default is NULL.}

\item{output_dir}{name of directory to generate report file. default is tempdir().}

\item{browse}{logical. choose whether to output the report results to the browser.}

\item{title}{character. title of report. default is "Data Diagnosis Report".}

\item{subtitle}{character. subtitle of report. default is name of data.}

\item{author}{character. author of report. default is "dlookr".}

\item{abstract_title}{character. abstract title of report. default is 
"Report Overview".}

\item{abstract}{character. abstract of report.}

\item{title_color}{character. color of title. default is "white".}

\item{subtitle_color}{character. color of subtitle. default is "tomato1".}

\item{cover_img}{character. name of cover image.}

\item{create_date}{Date or POSIXct, character. The date on which the report is generated. 
The default value is the result of Sys.time().}

\item{logo_img}{character. name of logo image file on top right.}

\item{theme}{character. name of theme for report. support "orange" and "blue". 
default is "orange".}

\item{sample_percent}{numeric. Sample percent of data for performing Diagnosis. 
It has a value between (0, 100]. 100 means all data, and 5 means 5\% of sample data.
This is useful for data with a large number of observations.}

\item{base_family}{character. The name of the base font family to use 
for the visualization. If not specified, the font defined in dlookr is applied. (See details)}

\item{...}{arguments to be passed to methods.}
}
\description{
The eda_paged_report() paged report the information for data transformatiom.
}
\details{
Generate transformation reports automatically. 
You can choose to output to pdf and html files.
This is useful for Binning a data frame with a large number of variables 
than data with a small number of variables.

Create an  PDF through the Chrome DevTools Protocol. If you want to create PDF, 
Google Chrome or Microsoft Edge (or Chromium on Linux) must be installed prior to using this function.
If not installed, you must use output_format = "html".
}
\section{Reported information}{

TThe transformation process will report the following information:

\itemize{
  \item Overview
  \itemize{
    \item Data Structures 
    \item Job Informations
  } 
  \item Imputation
  \itemize{
    \item Missing Values
    \item Outliers
  } 
  \item Resolving Skewness
  \item Binning
  \item Optimal Binning
}

The base_family is selected from "Roboto Condensed", "Liberation Sans Narrow",
"NanumSquare", "Noto Sans Korean". If you want to use a different font, 
use it after loading the Google font with import_google_font().
}

\examples{
\dontrun{
# create pdf file. file name is Transformation_Paged_Report.pdf
# transformation_paged_report(heartfailure, sample_percent = 80)

# create pdf file. file name is Transformation_heartfailure. and change cover image
# cover <- file.path(system.file(package = "dlookr"), "report", "cover2.jpg")
# transformation_paged_report(heartfailure, cover_img = cover, title_color = "gray",
#   output_file = "Transformation_heartfailure")

# create pdf file. file name is ./Transformation.pdf and not browse
# cover <- file.path(system.file(package = "dlookr"), "report", "cover1.jpg")
# transformation_paged_report(heartfailure, output_dir = ".", cover_img = cover, 
#   flag_content_missing = FALSE, output_file = "Transformation.pdf", browse = FALSE)

# create pdf file. file name is Transformation_Paged_Report.html
# transformation_paged_report(heartfailure, target = "death_event", output_format = "html")
}

}
