% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.R
\name{diagnose_web_report}
\alias{diagnose_web_report}
\alias{diagnose_web_report.data.frame}
\title{Reporting the information of data diagnosis with html}
\usage{
diagnose_web_report(.data, ...)

\method{diagnose_web_report}{data.frame}(
  .data,
  output_file = NULL,
  output_dir = tempdir(),
  browse = TRUE,
  title = "Data Diagnosis",
  subtitle = deparse(substitute(.data)),
  author = "dlookr",
  title_color = "gray",
  thres_uniq_cat = 0.5,
  thres_uniq_num = 5,
  logo_img = NULL,
  create_date = Sys.time(),
  theme = c("orange", "blue"),
  sample_percent = 100,
  is_tbl_dbi = FALSE,
  base_family = NULL,
  ...
)
}
\arguments{
\item{.data}{a data.frame or a \code{\link{tbl_df}}.}

\item{...}{arguments to be passed to methods.}

\item{output_file}{name of generated file. default is NULL.}

\item{output_dir}{name of directory to generate report file. default is tempdir().}

\item{browse}{logical. choose whether to output the report results to the browser.}

\item{title}{character. title of report. default is "Data Diagnosis Report".}

\item{subtitle}{character. subtitle of report. default is name of data.}

\item{author}{character. author of report. default is "dlookr".}

\item{title_color}{character. color of title. default is "gray".}

\item{thres_uniq_cat}{numeric. threshold to use for "Unique Values - 
Categorical Variables". default is 0.5.}

\item{thres_uniq_num}{numeric. threshold to use for "Unique Values - 
Numerical Variables". default is 5.}

\item{logo_img}{character. name of logo image file on top left.}

\item{create_date}{Date or POSIXct, character. The date on which the report is generated. 
The default value is the result of Sys.time().}

\item{theme}{character. name of theme for report. support "orange" and "blue". 
default is "orange".}

\item{sample_percent}{numeric. Sample percent of data for performing Diagnosis. 
It has a value between (0, 100]. 100 means all data, and 5 means 5\% of sample data.
This is useful for data with a large number of observations.}

\item{is_tbl_dbi}{logical. whether .data is a tbl_dbi object.}

\item{base_family}{character. The name of the base font family to use 
for the visualization. If not specified, the font defined in dlookr is applied. (See details)}
}
\description{
The diagnose_web_report() report the information for diagnosing
the quality of the data.
}
\details{
Generate generalized data diagnostic reports automatically.
This is useful for diagnosing a data frame with a large number of variables
than data with a small number of variables.
}
\section{Reported information}{

Reported from the data diagnosis is as follows.

\itemize{
  \item Overview
  \itemize{
    \item Data Structures 
    \itemize{
      \item Data Structures
      \item Data Types
      \item Job Informations
    }
    \item Warnings
    \item Variables
  }
  \item Missing Values
  \itemize{
    \item List of Missing Values
    \item Visualization
  }   
  \item Unique Values
  \itemize{
    \item Categorical Variables
    \item Numerical Variables
  }
  \item Outliers
  \item Samples
  \itemize{
    \item Duplicated
    \item Heads
    \item Tails
  }
}

The base_family is selected from "Roboto Condensed", "Liberation Sans Narrow",
"NanumSquare", "Noto Sans Korean". If you want to use a different font, 
use it after loading the Google font with import_google_font().
}

\examples{
\dontrun{
# create dataset
heartfailure2 <- dlookr::heartfailure
heartfailure2[sample(seq(NROW(heartfailure2)), 20), "sodium"] <- NA
heartfailure2[sample(seq(NROW(heartfailure2)), 5), "smoking"] <- NA
heartfailure2[sample(seq(NROW(heartfailure2)), 2), "time"] <- 0
heartfailure2[sample(seq(NROW(heartfailure2)), 1), "creatinine"] <- -0.3
 
# create pdf file. file name is Diagnosis_Report.html
# diagnose_web_report(heartfailure2)

# file name is Diagn.html. and change logo image
# logo <- file.path(system.file(package = "dlookr"), "report", "R_logo_html.svg")
# diagnose_web_report(heartfailure2, logo_img = logo, title_color = "black",
#   output_file = "Diagn.html")

# file name is ./Diagn_heartfailure.html, "blue" theme and not browse
# diagnose_web_report(heartfailure2, output_dir = ".", author = "Choonghyun Ryu",
#   output_file = "Diagn_heartfailure.html", theme = "blue", browse = FALSE)
}

}
\seealso{
\code{\link{diagnose_web_report.tbl_dbi}}.
}
