% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_dbi.R
\name{diagnose_category.tbl_dbi}
\alias{diagnose_category.tbl_dbi}
\title{Diagnose data quality of categorical variables in the DBMS}
\usage{
\method{diagnose_category}{tbl_dbi}(.data, ..., top = 10,
  in_database = TRUE, collect_size = Inf)
}
\arguments{
\item{.data}{a tbl_dbi.}

\item{...}{one or more unquoted expressions separated by commas.
You can treat variable names like they are positions.
Positive values select variables; negative values to drop variables.
If the first expression is negative, diagnose_category() will automatically
start with all variables.
These arguments are automatically quoted and evaluated in a context where
column names represent column positions.
They support unquoting and splicing.}

\item{top}{an integer. Specifies the upper top rank to extract.
Default is 10.}

\item{in_database}{Specifies whether to perform in-database operations. 
If TRUE, most operations are performed in the DBMS. if FALSE, 
table data is taken in R and operated in-memory.}

\item{collect_size}{a integer. The number of data samples from the DBMS to R. 
Applies only if in_database = FALSE.}
}
\value{
an object of tbl_df.
}
\description{
The diagnose_category() produces information for 
diagnosing the quality of the character(CHAR, VARCHAR, VARCHAR2, etc.) 
column of the DBMS table through tbl_dbi.
}
\details{
The scope of the diagnosis is the occupancy status of the levels
in categorical data. If a certain level of occupancy is close to 100%,
then the removal of this variable in the forecast model will have to be
considered. Also, if the occupancy of all levels is close to 0%, this
variable is likely to be an identifier.
}
\section{Categorical diagnostic information}{

The information derived from the categorical data diagnosis is as follows.

\itemize{
\item variables : variable names
\item levels: level names
\item N : number of observation
\item freq : number of observation at the levles
\item ratio : percentage of observation at the levles
\item rank : rank of occupancy ratio of levels
}

See vignette("diagonosis") for an introduction to these concepts.
}

\examples{
library(dplyr)

# Generate data for the example
carseats <- ISLR::Carseats
carseats[sample(seq(NROW(carseats)), 20), "Income"] <- NA
carseats[sample(seq(NROW(carseats)), 5), "Urban"] <- NA

# connect DBMS
con_sqlite <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")

# copy carseats to the DBMS with a table named TB_CARSEATS
copy_to(con_sqlite, carseats, name = "TB_CARSEATS", overwrite = TRUE)

# Using pipes ---------------------------------
# Diagnosis of all categorical variables
con_sqlite \%>\% 
  tbl("TB_CARSEATS") \%>\% 
  diagnose_category()
  
# Positive values select variables
con_sqlite \%>\% 
  tbl("TB_CARSEATS") \%>\% 
  diagnose_category(Urban, US)
  
# Negative values to drop variables, and In-memory mode
con_sqlite \%>\% 
  tbl("TB_CARSEATS") \%>\% 
  diagnose_category(-Urban, -US, in_database = FALSE)
  
# Positions values select variables, and In-memory mode and collect size is 200
con_sqlite \%>\% 
  tbl("TB_CARSEATS") \%>\% 
  diagnose_category(7, in_database = FALSE, collect_size = 200) 
  
# Positions values select variables
con_sqlite \%>\% 
  tbl("TB_CARSEATS") \%>\% 
  diagnose_category(-7)
  
# Top rank levels with top argument
con_sqlite \%>\% 
  tbl("TB_CARSEATS") \%>\% 
  diagnose_category(top = 2)

# Using pipes & dplyr -------------------------
# Extraction of level that is more than 60\% of categorical data
con_sqlite \%>\% 
  tbl("TB_CARSEATS") \%>\% 
  diagnose_category()  \%>\%
  filter(ratio >= 60)
  
}
\seealso{
\code{\link{diagnose_category.data.frame}}, \code{\link{diagnose.tbl_dbi}}, \code{\link{diagnose_category.tbl_dbi}}, \code{\link{diagnose_numeric.tbl_dbi}}, \code{\link{diagnose_outlier.tbl_dbi}}.
}
