% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FisherF.R
\name{quantile.FisherF}
\alias{quantile.FisherF}
\title{Determine quantiles of an F distribution}
\usage{
\method{quantile}{FisherF}(x, probs, ...)
}
\arguments{
\item{x}{A \code{FisherF} object created by a call to \code{\link[=FisherF]{FisherF()}}.}

\item{probs}{A vector of probabilities.}

\item{...}{Unused. Unevaluated arguments will generate a warning to
catch mispellings or other possible errors.}
}
\value{
A vector of quantiles, one for each element of \code{probs}.
}
\description{
\code{quantile()} is the inverse of \code{cdf()}.
}
\examples{

set.seed(27)

X <- FisherF(5, 10, 0.2)
X

random(X, 10)

pdf(X, 2)
log_pdf(X, 2)

cdf(X, 4)
quantile(X, 0.7)

cdf(X, quantile(X, 0.7))
quantile(X, cdf(X, 7))
}
