% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preds.R
\name{preds}
\alias{preds}
\title{Predict parameters of a distreg models' target distribution}
\usage{
preds(model, newdata = NULL, what = "mean", vary_by = NULL)
}
\arguments{
\item{model}{A fitted distributional regression model object. Check supported
classes at \link{distreg_checker}.}

\item{newdata}{A data.frame with explanatory variables as columns, and rows
with the combinations you want to do predictions for. Furthermore, whether
or not to include the intercept has to be specified via a logical variable
\code{intercept}. If omitted, the average of the explanatory variables is
used (see \link{set_mean}).}

\item{what}{One of \code{"mean"} or \code{"samples"}. The default for bamlss
models is "samples", while the default for gamlss models is "mean". This
argument changes how the mean of the parameter is calculated. See details
for details.}

\item{vary_by}{Variable name in character form over which to vary the
mean/reference values of explanatory variables. It is passed to
\link{set_mean}. See that documentation for further details.}
}
\value{
A data.frame with one column for every distributional parameter and a
  row for every covariate combination that should be predicted.
}
\description{
This function takes a fitted model and a dataframe with explanatory variables
and a column for the intercept to compute predicted parameters for the
specified distribution. Without worrying about class-specific function
arguments, \code{preds()} offers a consistent way of obtaining predictions
based on specific covariate combinations.
}
\examples{
# Generating data
data_fam <- model_fam_data(fam_name = "BE")

# Fit model
library("gamlss")
beta_model <- gamlss(BE ~ norm2 + binomial1,
  data = data_fam, family = BE())

# Get 3 predictions
ndata <- data_fam[sample(1:nrow(data_fam), 3), c("binomial1", "norm2")]
preds(model = beta_model, newdata = ndata)

# If newdata argument is omitted preds uses the means of the explanatory variables
preds(model = beta_model, newdata = NULL) # this gives the same results as ...
preds(model = beta_model, newdata = set_mean(model_data(beta_model))) # ...this

}
