% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{dip8}
\alias{dip8}
\title{Parameter estimates of Weibull fit to individual dissolution profiles}
\format{
A data frame with 36 observations and 4 variables:
\describe{
  \item{tablet}{Factor with levels \code{1} to \code{12} representing
    individual tablets}
  \item{type}{Factor with levels \code{ref} (Reference), \code{minor} (Test)
    and \code{major} (Test)}
  \item{alpha}{Weibull parameter \eqn{\alpha}, i.e. the scale parameter
    being a function of the undissolved proportion at \eqn{t = 1}}
  \item{beta}{Weibull parameter \eqn{\beta}, i.e. the shape parameter
    which is related to the dissolution rate per unit of time}
}
}
\source{
See reference: Example data set shown in Table III.
}
\usage{
data(dip8)
}
\description{
A data set containing the Weibull parameter estimates obtained from fitting
  Weibull curves to the cumulative dissolution profiles of individual
  tablets of one reference batch and one test or post-change batch with a
  minor modification and a second test or post-change batch with a major
  modification, \eqn{n = 12} tablets each.
}
\examples{
str(dip8)
}
\references{
Sathe, P.M., Tsong, Y., and Shah, V.P. \emph{In-Vitro} dissolution profile
comparison: Statistics and analysis, model dependent approach.
\emph{Pharm Res}. 1996; \strong{13}(12): 1799-1803.\cr
\doi{10.1023/a:1016020822093}
}
\keyword{datasets}
