% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{dip7}
\alias{dip7}
\title{Parameter estimates of Weibull fit to individual dissolution profiles}
\format{
A data frame with 48 observations and 5 variables:
\describe{
  \item{tablet}{Factor with levels \code{1} to \code{12} representing
    individual tablets}
  \item{batch}{Factor with levels \code{b0}, \code{b1}, \code{b2}, \code{b3}
    and \code{b4}}
  \item{type}{Factor with levels \code{ref} (Reference) and \code{test}
    (Test)}
  \item{alpha}{Weibull parameter \eqn{\alpha}, i.e. the scale parameter
    being a function of the undissolved proportion at \eqn{t = 1}}
  \item{beta}{Weibull parameter \eqn{\beta}, i.e. the shape parameter
    which is related to the dissolution rate per unit of time}
}
}
\source{
See reference: Example data set shown in Table 4.
}
\usage{
data(dip7)
}
\description{
A data set containing the Weibull parameter estimates obtained from fitting
  Weibull curves to the cumulative dissolution profiles of individual
  tablets of three reference batches and one test batch, \eqn{n = 12}
  tablets each. The Weibull curve is fitted according to the formula
  \eqn{x(t) = x_{max} ( 1 - exp(- \alpha t^{\beta}))}, where \eqn{x(t)} is
  the percent released at time \eqn{t} divided by \eqn{100}, \eqn{x_{max}}
  is the maximal release (set to be \eqn{100}, i.e. assumed to be a
  constant).
}
\examples{
str(dip7)
}
\references{
Tsong, Y., Hammerstrom, T., Chen, J.J. Multipoint dissolution specification
and acceptance sampling rule based on profile modeling and principal
component analysis. \emph{J Biopharm Stat}. 1997; \strong{7}(3): 423-439.\cr
\doi{10.1080/10543409708835198}
}
\keyword{datasets}
