% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pgls.dispRity.R
\name{pgls.dispRity}
\alias{pgls.dispRity}
\title{phylolm dispRity (from \code{phylolm::phylolm})}
\usage{
pgls.dispRity(data, tree, formula, model = "BM", ..., optim = list())
}
\arguments{
\item{data}{A \code{dispRity} object with a metric of dimension level 2 at least}

\item{tree}{If \code{data} does not contain a tree component, a \code{"phylo"} or \code{"multiPhylo"} object to be used as the tree. If \code{data} already contains a tree component and the \code{tree} argument is not missing, the provided \code{tree} will replace any contained in \code{data}.}

\item{formula}{The PGLS formula. If left empty, runs either \code{disparity ~ 1} or \code{disparity ~ subsets} if \code{data} contains subsets.}

\item{model}{The covariance model (default is \code{"BM"}). For more details (including the models available) see the manual for \code{\link[phylolm]{phylolm}}.}

\item{...}{Any optional arguments to be passed to \code{\link[phylolm]{phylolm}}}

\item{optim}{An optional named list of arguments to be passed to the function \code{optim}}
}
\description{
Passing \code{dispRity} objects to the \code{\link[phylolm]{phylolm}} function from the \code{phylolm} package. Typically to run some PGLS.
}
\details{
The \code{formula} needs to be expressed by always naming the response variable \code{disparity} to use the calculated disparity data from \code{data}.

Optional arguments \code{...} correspond to all the non-ambiguous named arguments from the \code{\link[phylolm]{phylolm}}. Optional arguments for the internal \code{optim} function can be passed as a named list to the \code{optim} argument.
}
\examples{
## Simple example
data(BeckLee_mat50)
data(BeckLee_tree)
disparity <- dispRity(BeckLee_mat50, metric = centroids, tree = BeckLee_tree)

## Running a simple PGLS
model <- pgls.dispRity(disparity)
summary(model)

## More complex example running a PGLS
## on multiple trees and using groups as a predictor 

}
\seealso{
\code{\link[phylolm]{phylolm}}, \code{\link{test.dispRity}}, \code{\link{custom.subsets}}, \code{\link{chrono.subsets}}.
}
\author{
Thomas Guillerme
}
