% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrim-package.R
\docType{package}
\name{discrim-package}
\alias{discrim}
\alias{discrim-package}
\title{parsnip methods for discriminant analysis}
\description{
\pkg{discrim} offers various functions to fit classification models via the
discriminant analysis.
}
\details{
The model function works with the tidymodels infrastructure so that the model
can be resampled, tuned, tided, etc.
}
\section{Example}{
As an example, we’ll use a \emph{flexible discriminant analysis} model of
Hastie, Tibshirani, and Buja (1994). This fits a model that uses
features generated by the multivariate adaptive regression spline (MARS)
model of Friedman (1991). It is able to create class boundaries that are
polygons and has built-in feature selection.

The \code{parabolic} data from the modeldata package will be used to
illustrate:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(tidymodels)
library(discrim)
tidymodels_prefer()
theme_set(theme_bw())

data(parabolic, package = "modeldata")
}\if{html}{\out{</div>}}

To create the model, the \code{discrim_flexible()} function is used along
with an engine of \code{"earth"} (which contains the methods to use the MARS
model). We’ll set the number of MARS terms to use but this can be tuned
via the methods in the tune package.

The \code{fit()} function estimates the model. \code{fit_xy()} can be used if one
does not wish to use the formula method.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{fda_mod <-
  discrim_flexible(num_terms = 3) |>
  # increase `num_terms` to find smoother boundaries
  set_engine("earth") |>
  fit(class ~ ., data = parabolic)
fda_mod
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## parsnip model object
## 
## Call:
## mda::fda(formula = class ~ ., data = data, method = earth::earth, 
##     nprune = ~3)
## 
## Dimension: 1 
## 
## Percent Between-Group Variance Explained:
##  v1 
## 100 
## 
## Training Misclassification Error: 0.136 ( N = 500 )
}\if{html}{\out{</div>}}

Now let’s plot the class boundary by predicting on a grid of points then
creating a contour plot for the 50\% probability cutoff.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{parabolic_grid <-
  expand.grid(X1 = seq(-5, 5, length = 100),
              X2 = seq(-5, 5, length = 100))

parabolic_grid <- 
  parabolic_grid |> 
  bind_cols(
    predict(fda_mod, parabolic_grid, type = "prob")
  )

ggplot(parabolic, aes(x = X1, y = X2)) +
  geom_point(aes(col = class), alpha = .5) +
  geom_contour(data = parabolic_grid, aes(z = .pred_Class1), col = "black", breaks = .5) +
  coord_equal()
}\if{html}{\out{</div>}}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/tidymodels/discrim}
  \item \url{https://discrim.tidymodels.org/}
  \item Report bugs at \url{https://github.com/tidymodels/discrim/issues}
}

}
\author{
\strong{Maintainer}: Emil Hvitfeldt \email{emil.hvitfeldt@posit.co} (\href{https://orcid.org/0000-0002-0679-1945}{ORCID})

Authors:
\itemize{
  \item Max Kuhn \email{max@posit.co} (\href{https://orcid.org/0000-0003-2402-136X}{ORCID})
}

Other contributors:
\itemize{
  \item Posit Software, PBC (03wc8by49) [copyright holder, funder]
}

}
\keyword{internal}
