% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod_cluster_utils.R
\name{hc_vert}
\alias{hc_vert}
\title{Vertical representation for centers of clusters.}
\usage{
hc_vert(centros, nombre.archivo = NULL, colors = NULL, btntext = "Volver")
}
\arguments{
\item{centros}{a data.frame object with the centers of the clusters.}

\item{nombre.archivo}{a character value specifying the name to use when the plot is downloaded.}

\item{colors}{a vector of color for each cluster.}

\item{btntext}{a character value for the label of button to back.}
}
\value{
Highchart plot
}
\description{
Vertical representation for centers of clusters.
}
\examples{
clusters <- factor(kmeans(iris[, -5], 3)$cluster)
c <- calc.centros(iris[, -5], clusters)
hc_vert(c$real, 'vertical', c("steelblue", "pink", "forestgreen"))

}
\author{
Diego Jimenez <diego.jimenez@promidat.com>
}
