% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/debris_id.R
\name{call_targets}
\alias{call_targets}
\title{Call clean droplets after running EM}
\usage{
call_targets(x, pp_thresh = 0.95, min_genes = 200)
}
\arguments{
\item{x}{An SCE object.}

\item{pp_thresh}{The minimum posterior probability of a droplet to be 
classified as a cell/nucleus.}

\item{min_genes}{The minimum number of genes a droplet must have 
to be classified as a cell/nucleus.}
}
\value{
An SCE object.
}
\description{
Call cells or nuclei from an SCE object. EM must be run beforehand.
The posterior probability is defined as 1 - Prob(Debris), where 
Prob(Debris) is the posterior probability that a droplet is 
debris.
}
