% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expand_rownames.r
\name{expand_rownames}
\alias{expand_rownames}
\title{\code{expand_rownames}: expand parameter descriptions in rownames}
\usage{
expand_rownames(x, time_name, geo_name, group_names)
}
\arguments{
\item{x}{A table with rownames in the format \code{param[group1__groupK,t]}
or \code{param[t]}.}

\item{time_name}{A name for any resulting time variable.}

\item{geo_name}{A name for any resulting geographic variable.}

\item{group_names}{Names for any resulting group variables.}
}
\value{
\code{x} with additional columns (see details).
}
\description{
Move rownames that describe parameters (e.g. xi[2009]) to columns.
}
\details{
It should rarely be necessary to call \code{expand_rownames} directly. But
elements extracted from \code{\link{dgirtfit}}-class objects may have
rownames of the format \code{param[group1__groupK,t]} for parameters indexed
by group and time period, or \code{param[t]} for parameters indexed by time
period. \code{expand_rownames} moves this information to columns whose names
are given by the \code{col_names} argument. The rownames in their original
format will appear in another column called \code{rn}.
}
\seealso{
\code{\link{dgirtfit-class}}
}
