% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{gsi}
\alias{gsi}
\title{Calculate the growth suppression index}
\usage{
gsi(input_series)
}
\arguments{
\item{input_series}{A \code{dplr::rwl} object with the host tree series as the
first column and the non-host chronology as the second. Years should be the
row names. This is specifically created by \code{\link[=defoliate_trees]{defoliate_trees()}} and
passed to \code{\link[=gsi]{gsi()}}.}
}
\value{
A data frame with the two input columns (host and nonhost series) and
3 added columns:

\enumerate{ \item The mean/sd adjusted non-host chronology, \item The
growth suppression index ("gsi") of the host series after subtraction of
the adjusted nonhost chronology, \item The normalized growth suppression
index ("ngsi") generated by applying \code{\link[=scale]{scale()}} to the gsi. }
}
\description{
This function removes the nonhost growth signal from a host tree-ring series.
}
\details{
The growth suppression index (GSI) is referred to as the "corrected"
series in OUTBREAK. It is calculated as:

\deqn{GSI(i) = H(i) - (NH(i) - mean(NH)) sd(H)/sd(NH)}

where H and NH are the host and nonhost tree-ring series as standardized
index values; i is the year, and the functions \code{\link[=mean]{mean()}} and \code{\link[=sd]{sd()}} are
applied to the common period.

\code{\link[=gsi]{gsi()}} will rarely be run directly by a user. It is called from
\code{\link[=defoliate_trees]{defoliate_trees()}}.
}
