% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lme_model6.r
\name{lmmDyn}
\alias{lmmDyn}
\title{Semiparametric modelling - dynamic functional connectivity model}
\usage{
lmmDyn(dataList, op_lme)
}
\arguments{
\item{dataList}{list, a list of data matrices.}

\item{op_lme}{list, options constructed by function \code{options_lme}, see \code{options_lme}.}
}
\value{
An object of list containing all the information of the static functional connectivity linear mixed model. It stores the information of model parameters, input data, and model results. 
\describe{
\item{params}{Store the parameters for the linear mixed model}
\item{parallel}{Store the information about parallel computing environment and parameters}
\item{output_by_row}{Store the model results information for data between each pair of regions}
\item{modelDyn_results}{A combined dataframe with all the model results informations}
\item{est_CI}{A list of matrices, contains information of confidence band estimate, see description below.}
In each matrix of \code{est_CI}:

  \item{row 1}{Base line estimate, difference between condition 1 and condition 2}
  \item{row 2}{Dynamic functional connecvity estimates for condition 1}
  \item{row 3}{Dynamic functional connecvity estimates for condition 2}
  \item{row 4}{Lower bound of 95\% confidence interval of condition-difference estimates}
  \item{row 5}{Upper bound of 95\% confidence interval of condition-difference estimates}
  \item{row 6}{Lower bound of 95\% confidence interval of condition-1 estimates}
  \item{row 7}{Upper bound of 95\% confidence interval of condition-1 estimates}
  \item{row 8}{Lower bound of 95\% confidence interval of condition-2 estimates}
  \item{row 9}{Upper bound of 95\% confidence interval of condition-2 estimates}
}
}
\description{
Linear mixed effect model for dynamic functional connectivity.
}
\details{
The output of \code{MLPB_boot} is a complete bootstrapping result for the dynamic functional connectivity (dFC) estimates of each pair of region of interest, however, for further analysis, like \code{lmmDyn} and \code{lmmConn}, we need to summarize the bootstrapping by taking the mean or median of the dFC estimate at each time point.
}
\examples{
\dontshow{
# Example for testing
# Assuming user has run \\code{MLPB_boot} and has summarize the bootstrapping result

data(MLPB_output_median)
dataList <- list(median_1_2 = MLPB_output_median[[1]])
subjects <- c('subject1', 'subject2', 'subject3', 'subject4', 'subject5')

# In our demo data, each subject has a scan with a total of 90 time points
time.points <- c(1:40,51:90) 
                 
num.scan <- 2 # Each subject has 2 scans

op <- options_lme(effective_tp = time.points, 
                 ntps.per.scan = 40,
                 subjects = subjects, 
                 num.scan = 2)
                 
resDyn <- lmmDyn(dataList, op)
rm(list = c('subjects', 'MLPB_output_median', 'time.points', 'num.scan', 'ntps.per.scan', 'resDyn'))
gc()
}
\donttest{
# Assuming user has run MLPB_boot() and has summarize the bootstrapping result

data("MLPB_output_median")

subjects <- c('subject1', 'subject2', 'subject3', 'subject4', 'subject5')

# In our demo data, each subject has a scan with a total of 750 time points
time.points <- c(1:105, 126:230, 251:355,
                 376:480, 501:605, 626:730) 
                 
                 
num.scan <- 6 # Each subject has 6 scans
ntps.per.scan <- 105 # Each scan has 105 time points

op <- options_lme(effective_tp = time.points, 
                 ntps.per.scan = ntps.per.scan,
                 subjects = subjects, 
                 num.scan = num.scan, 
                 cores = 5)
                 
resDyn <- lmmDyn(MLPB_output_median, op)
}
}
