% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/revdep-summarise.R, R/revdep.R
\name{revdep_check_save_logs}
\alias{revdep_check}
\alias{revdep_check_save_logs}
\alias{revdep_check_save_summary}
\alias{revdep_check_summary}
\title{Run R CMD check on all downstream dependencies.}
\usage{
revdep_check_save_logs(res, log_dir = "revdep")

revdep_check_save_summary(res, log_dir = "revdep")

revdep_check_summary(res)

revdep_check(pkg = ".", recursive = FALSE, ignore = NULL,
  dependencies = c("Depends", "Imports", "Suggests", "LinkingTo"),
  libpath = getOption("devtools.revdep.libpath"), srcpath = libpath,
  bioconductor = FALSE, type = getOption("pkgType"),
  threads = getOption("Ncpus", 1), check_dir = tempfile("check_cran"))
}
\arguments{
\item{res}{Result of \code{revdep_check}}

\item{log_dir}{Directory in which to save logs}

\item{pkg}{Path to package. Defaults to current directory.}

\item{recursive}{If \code{TRUE} look for full set of recursive dependencies.}

\item{ignore}{A character vector of package names to ignore. These packages
will not appear in returned vector. This is used in
\code{\link{revdep_check}} to avoid packages with installation problems
or extremely long check times.}

\item{dependencies}{A character vector listing the types of dependencies
to follow.}

\item{libpath}{Path to library to store dependencies packages - if you
you're doing this a lot it's a good idea to pick a directory and stick
with it so you don't have to download all the packages every time.}

\item{srcpath}{Path to directory to store source versions of dependent
packages - again, this saves a lot of time because you don't need to
redownload the packages every time you run the package.}

\item{bioconductor}{If \code{TRUE} also look for dependencies amongst
bioconductor packages.}

\item{type}{binary Package type to test (source, mac.binary etc). Defaults
to the same type as \code{\link{install.packages}()}.}

\item{threads}{Number of concurrent threads to use for checking.
It defaults to the option \code{"Ncpus"} or \code{1} if unset.}

\item{check_dir}{Directory to store results.}
}
\value{
An invisible list of results. But you'll probably want to look
  at the check results on disk, which are saved in \code{check_dir}.
  Summaries of all ERRORs and WARNINGs will be stored in
  \code{check_dir/00check-summary.txt}.
}
\description{
Use \code{revdep_check()} to run \code{\link{check_cran}()} on all downstream
dependencies. Summarises the results with \code{revdep_check_summary} and
save logs with \code{revdep_check_save_logs}.
}
\section{Check process}{

\enumerate{
\item Install \code{pkg} (in special library, see below).
\item Find all CRAN packages that depend on \code{pkg}.
\item Install those packages, along with their dependencies.
\item Run \code{R CMD check} on each package.
\item Uninstall \code{pkg} (so other reverse dependency checks don't
  use the development version instead of the CRAN version)
}
}

\section{Package library}{

By default \code{revdep_check} uses a temporary library to store any packages
that are required by the packages being tested. This ensures that they don't
interfere with your default library, but means that if you restart R
between checks, you'll need to reinstall all the packages. If you're
doing reverse dependency checks frequently, I recommend that you create
a directory for these packages and set \code{options(devtools.revdep.libpath)}.
}
\examples{
\dontrun{
# Run R CMD check on all downstream dependencies of ggplot2
res <- revdep_check("ggplot2")
revdep_check_summary(res)
revdep_check_save_logs(res)
}
}
\seealso{
\code{\link{revdep_maintainers}()} to run R CMD check on all reverse
  dependencies.
}

