% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ratkowsky_82}
\alias{ratkowsky_82}
\title{Ratkowsky equation of development rate as a function of temperature (Shi modification).}
\format{
A list of eight elements describing the equation.
\describe{
  \item{eq}{The equation (formula object).}
  \item{eqAlt}{The equation (string).}
  \item{name}{The name of the equation.}
  \item{ref}{The equation reference.}
  \item{refShort}{The equation reference shortened.}
  \item{startVal}{The parameters found in the literature with their references.}
  \item{com}{An optional comment about the equation use.}
  \item{id}{An id to identify the equation.}
}
}
\source{
\url{https://jb.asm.org/content/149/1/1}

\url{https://jb.asm.org/content/154/3/1222}
}
\usage{
ratkowsky_82
}
\description{
Ratkowsky, D.A., Olley, J., McMeekin, T.A., and Ball, A. (1982) Relationship between
temperature and growth rate of bacterial cultures. Journal of Bacteriology 149(1): 1-5.

Ratkowsky, D.A., R.K. Lowry, T.A. McMeekin, A.N. Stokes, and R.E. Chandler. 1983.
Model for bacterial culture growth rate throughout the entire biokinetic temperature range.
Journal of Bacteriology 154: 1222-1226.

Shi, P., Ge, F., Sun, Y., and Chen, C. (2011) A simple model for describing the effect of
temperature on insect developmental rate. Journal of Asia-Pacific Entomology 14(1): 15-20.
}
\details{
Equation:
\deqn{rT = (\sqrt{cc} * k1 * (T - T1) * (1 - e^{k2 * (T - T2)}))^{2}}{%
      rT = (sqrt(cc) * k1 * (T - T1) * (1 - exp(k2 * (T - T2))))^2}

where rT is the development rate, T the temperature, T1 and T2 the minimum
and maximum temperatures at which rate of growth is zero, sqrt(cc) * k1 the slope of the
regression as in the rootsq_82 equation, and k2 a constant. The Ratkowsky model designed
for microorganisms has been modified by Shi et al. 2011 to describe the temperature-dependent
development rates of insects.
}
\keyword{datasets}
