% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/details.R
\name{details}
\alias{details}
\title{Create HTML DOM Details}
\usage{
details(object, summary = NULL, tooltip = "Click to Expand",
  open = FALSE, lang = "r", output = c("console", "clipr", "edit",
  "character"))
}
\arguments{
\item{object}{object, object to put in details block}

\item{summary}{character, text to put in summary block, Default: NULL}

\item{tooltip}{character, text for tooltip on the summary,
Default: 'Click to Expand'}

\item{open}{logical, is the details open (TRUE) or closed (FALSE),
Default: FALSE}

\item{lang}{character, language of block (for markdown highlighting)
Default: 'r'}

\item{output}{character, where to output the file console (Default),
clipboard or R file editor,
Default: c('console','clipr','file.edit','character')}
}
\value{
character
}
\description{
Create HTLM DOM Details block for Markdown documents
with summary as optional.
}
\details{
To remove summary or tooltip set them to NULL.
If the object is a file path, it will automatically it's lines will be read
in internally.

If lang is NULL then the output will not be wrapped in a code block and
will display the raw output (useful for HTML)

When using details in knitr/rmarkdown documents there is no need to set
the results to 'asis', there are already predefined print methods for these
environments.
}
\examples{

#basic
 details::details('test')

#sessionInfo
 details::details(sessionInfo(), summary = 'sessionInfo')

#data.frame
 details::details(head(mtcars))

#plots
\donttest{
 details(
   plot(x = mtcars$mpg, y = mtcars$wt),
   summary = 'Plots')
}

#output options

#character
 details::details('test', output = 'character')

#clipboard
if(clipr::clipr_available()){

 details::details('test', output = 'clipr')

 clipr::read_clip()

}

#file.edit
\donttest{

 details::details('test', output = 'edit')
 
}



}
