% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitting_functions.R
\name{llin_decomp}
\alias{llin_decomp}
\title{Decomposition of Time Series Using Local Linear Regression}
\usage{
llin_decomp(
  yt,
  bwidth_trend = 4,
  bwidth_season = 5,
  kernel_par = 1,
  boundary_method = c("extend", "shorten"),
  season = NULL
)
}
\arguments{
\item{yt}{a time series object of class \code{"ts"} or an object that can be 
transformed to that class using \code{\link[stats]{as.ts}}.}

\item{bwidth_trend}{half of the absolute bandwidth (in years); represents the 
amount of data to use around the estimation time point to consider 
for trend smoothing.}

\item{bwidth_season}{half of the absolute bandwidth (in years); represents the
amount of data (only from the same quarter, month, etc.) to use around the 
estimation time point for the seasonality estimation.}

\item{kernel_par}{the smoothness parameter for the second-order kernel function 
used in the weighting process; for \code{kernel_par = 0} a uniform kernel 
is used, for \code{kernel_par = 1} an epanechnikov kernel, and so on.}

\item{boundary_method}{a single character value; it indicates, what bandwidth 
method to use at boundary points; for \code{"extend"}, the default, the 
smoothing window around boundary points will be extended towards the center of 
the data; for \code{"shorten"}, the window width will keep decreasing at 
boundary points when approaching the very first and the very last observation.}

\item{season}{the seasonal period in \code{yt}; by default, the seasonal 
period is obtained automatically from \code{yt}.}
}
\value{
An S4 object with the following elements is returned.
\describe{
\item{decomp}{an object of class \code{"mts"} that consists of the
decomposed time series data.}
\item{ts_name}{the object name of the initially provided time series object.}
\item{frequency}{the frequency of the time series.}
\item{bwidth_trend}{the same as the input argument \code{bwidth_trend}.}
\item{bwidth_season}{the same as the input argument \code{bwidth_season}.}
\item{boundary_method}{the same as the input argument \code{boundary_method}.}
\item{kernel_par}{the same as the input argument \code{kernel_par}.}
}
}
\description{
Trend and seasonality are modelled in a two-step approach, where first the 
trend is being estimated using local linear regression and then the 
seasonality is being estimated using various local linear regressions as 
well. In both cases a manually selected bandwidth is required.
}
\details{
Apply local linear regression to estimate trend and seasonality 
in a given time series \eqn{y_t}. Assume that \eqn{y_t} follows an additive 
component model with trend and seasonality components. First, a local linear 
regression with a first (absolute) bandwidth is conducted to estimate the trend 
from the series. If the seasonal period is \eqn{s}, then afterwards \eqn{s} 
local linear regressions (for each individual seasonal subseries of the 
detrended series) are conducted with a second (absolute) bandwidth to obtain 
seasonality estimates.
}
\examples{
est <- llin_decomp(log(EXPENDITURES), bwidth_trend = 4, bwidth_season = 28)
est

}
\author{
\itemize{
\item Dominik Schulz (Research Assistant) (Department of Economics, Paderborn
University), \cr
Author and Package Creator
}
}
