% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BoundingCovariateEffects.R
\name{set.hyperparameters}
\alias{set.hyperparameters}
\title{Define the hyperparameters used for finding the identified interval}
\usage{
set.hyperparameters(data, par.space, c, search.method, options)
}
\arguments{
\item{data}{Data frame.}

\item{par.space}{Bounds on the parameter space.}

\item{c}{Projection vector.}

\item{search.method}{Search method to use (\code{"EAM"} or \code{"GS"})}

\item{options}{List of user specified hyperparameters that will substitute
the corresponding default values. This list can contain the entries:
\describe{
 \item{cov.ranges:}{known bounds on each of the covariates in the data set.}
 \item{norm.func.name:}{Name of the normalization function to be used. Can
 be either "normalize.covariates1" or "normalize.covariates2" (default).
 The former is a simple elementwise rescaling. The latter uses the PCA
 approach as discussed in Willems et al. (2024+).}
 \item{inst.func.family:}{Family of instrumental functions to be used for
 all covariates. Options are "box", "spline" and "cd". The former two are
 only applicable for continuous covariates. The latter can also handle
 discrete covariates. Default is "cd".}
 \item{G.c:}{The class of instrumental functions used for the continuous
 covariates in the model, in case "cd" is selected as
 \code{inst.func.family:}. Options are "box" and "spline". Default is
 "spline".}
 \item{degree:}{The degree of the B-spline functions, should they be used as
 instrumental functions for the continuous covariates. Default is 3.}
 \item{link.function:}{Name of the link function to be used. Options are
 "AFT_ll" for the AFT model with log-logistic baseline, or "Cox_wb" for the
 Cox PH model (originally with Weibull baseline, but now for a general)
 baseline hazard).}
 \item{K.bar:}{Number of refinement steps when obtaining the critical value.
 See Bei (2024).}
 \item{B:}{Number of bootstrap samples to be used when obtaining the
 bootstrap distribution of the test statistic.}
 \item{ignore.empty.IF:}{Boolean value indicating whether instrumental
 functions with empty support should be ignored (cf. Willems et al., 2024).
 Default is FALSE. The feature \code{ignore.empty.IF = TRUE} is experimental,
 so there might exist edge cases for which the implementation will fail to
 run.}
}
Other (hidden) options can also be overwritten, though we highly discourage
this. If necessary, you can consult the source code of this functions to
find the names of the desired parameters and add their name alongside their
desired value as an entry in \code{options} (e.g.
\code{options$min.var <- 1e-4}. Again, not recommended!).}
}
\value{
The list of hyperparameters.
}
\description{
This function defines all the necessary hyperparameters used to
run the methodology.
}
