% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CopulaBasedCoxPH_pseudoLikelihoodFunctions.R
\name{LikCopInd}
\alias{LikCopInd}
\title{Loglikehood function under independent censoring}
\usage{
LikCopInd(theta, resData, X, W, lhat, cumL, dist)
}
\arguments{
\item{theta}{Estimated parameter values/initial values for finite dimensional parameters}

\item{resData}{Data matrix with three columns;  Z = the observed survival time, d1 = the censoring indicator of T
and  d2 =  the censoring indicator of C.}

\item{X}{Data matrix with covariates related to T}

\item{W}{Data matrix with covariates related to C. First column of W should be ones}

\item{lhat}{The estimated hazard function obtained from the output of \code{\link{SolveLI}}.}

\item{cumL}{The estimated cumulative hazard function from the output of \code{\link{SolveLI}}.}

\item{dist}{The distribution to  be used for the dependent censoring C. Only two distributions are allowed, i.e, Weibull
and lognormal distributions. With the value \code{"Weibull"} as the
  default.
 @importFrom stats nlminb pnorm  qnorm sd}
}
\value{
Maximized log-likelihood value
}
\description{
Loglikehood function under independent censoring
}
